package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsCheckUserRequest {
  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("userCode")
  private String userCode = null;

  @JsonProperty("userNumber")
  private String userNumber = null;

  @JsonProperty("userPhone")
  private String userPhone = null;

  @JsonProperty("userEmailAddr")
  private String userEmailAddr = null;

  @JsonProperty("userIdCard")
  private String userIdCard = null;

  @JsonIgnore
  public MsCheckUserRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 人员Id
   * @return userId
  **/
  @ApiModelProperty(value = "人员Id")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsCheckUserRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户Id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户Id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsCheckUserRequest userCode(String userCode) {
    this.userCode = userCode;
    return this;
  }

   /**
   * 人员代码
   * @return userCode
  **/
  @ApiModelProperty(value = "人员代码")
  public String getUserCode() {
    return userCode;
  }

  public void setUserCode(String userCode) {
    this.userCode = userCode;
  }

  @JsonIgnore
  public MsCheckUserRequest userNumber(String userNumber) {
    this.userNumber = userNumber;
    return this;
  }

   /**
   * 人员工号
   * @return userNumber
  **/
  @ApiModelProperty(value = "人员工号")
  public String getUserNumber() {
    return userNumber;
  }

  public void setUserNumber(String userNumber) {
    this.userNumber = userNumber;
  }

  @JsonIgnore
  public MsCheckUserRequest userPhone(String userPhone) {
    this.userPhone = userPhone;
    return this;
  }

   /**
   * 手机号码
   * @return userPhone
  **/
  @ApiModelProperty(value = "手机号码")
  public String getUserPhone() {
    return userPhone;
  }

  public void setUserPhone(String userPhone) {
    this.userPhone = userPhone;
  }

  @JsonIgnore
  public MsCheckUserRequest userEmailAddr(String userEmailAddr) {
    this.userEmailAddr = userEmailAddr;
    return this;
  }

   /**
   * 邮箱地址
   * @return userEmailAddr
  **/
  @ApiModelProperty(value = "邮箱地址")
  public String getUserEmailAddr() {
    return userEmailAddr;
  }

  public void setUserEmailAddr(String userEmailAddr) {
    this.userEmailAddr = userEmailAddr;
  }

  @JsonIgnore
  public MsCheckUserRequest userIdCard(String userIdCard) {
    this.userIdCard = userIdCard;
    return this;
  }

   /**
   * 身份证号
   * @return userIdCard
  **/
  @ApiModelProperty(value = "身份证号")
  public String getUserIdCard() {
    return userIdCard;
  }

  public void setUserIdCard(String userIdCard) {
    this.userIdCard = userIdCard;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCheckUserRequest checkUserRequest = (MsCheckUserRequest) o;
    return Objects.equals(this.userId, checkUserRequest.userId) &&
        Objects.equals(this.tenantId, checkUserRequest.tenantId) &&
        Objects.equals(this.userCode, checkUserRequest.userCode) &&
        Objects.equals(this.userNumber, checkUserRequest.userNumber) &&
        Objects.equals(this.userPhone, checkUserRequest.userPhone) &&
        Objects.equals(this.userEmailAddr, checkUserRequest.userEmailAddr) &&
        Objects.equals(this.userIdCard, checkUserRequest.userIdCard);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userId, tenantId, userCode, userNumber, userPhone, userEmailAddr, userIdCard);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCheckUserRequest {\n");
    
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    userCode: ").append(toIndentedString(userCode)).append("\n");
    sb.append("    userNumber: ").append(toIndentedString(userNumber)).append("\n");
    sb.append("    userPhone: ").append(toIndentedString(userPhone)).append("\n");
    sb.append("    userEmailAddr: ").append(toIndentedString(userEmailAddr)).append("\n");
    sb.append("    userIdCard: ").append(toIndentedString(userIdCard)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
