package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsCompanyModel {
  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("companyCode")
  private String companyCode = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("taxNum")
  private String taxNum = null;

  @JsonIgnore
  public MsCompanyModel companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 主键ID
   * @return companyId
  **/
  @ApiModelProperty(value = "主键ID")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsCompanyModel companyCode(String companyCode) {
    this.companyCode = companyCode;
    return this;
  }

   /**
   * 公司代码
   * @return companyCode
  **/
  @ApiModelProperty(value = "公司代码")
  public String getCompanyCode() {
    return companyCode;
  }

  public void setCompanyCode(String companyCode) {
    this.companyCode = companyCode;
  }

  @JsonIgnore
  public MsCompanyModel companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsCompanyModel taxNum(String taxNum) {
    this.taxNum = taxNum;
    return this;
  }

   /**
   * 公司税号
   * @return taxNum
  **/
  @ApiModelProperty(value = "公司税号")
  public String getTaxNum() {
    return taxNum;
  }

  public void setTaxNum(String taxNum) {
    this.taxNum = taxNum;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCompanyModel companyModel = (MsCompanyModel) o;
    return Objects.equals(this.companyId, companyModel.companyId) &&
        Objects.equals(this.companyCode, companyModel.companyCode) &&
        Objects.equals(this.companyName, companyModel.companyName) &&
        Objects.equals(this.taxNum, companyModel.taxNum);
  }

  @Override
  public int hashCode() {
    return Objects.hash(companyId, companyCode, companyName, taxNum);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCompanyModel {\n");
    
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    companyCode: ").append(toIndentedString(companyCode)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    taxNum: ").append(toIndentedString(taxNum)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
