package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.ucenter.client.model.MsDoID;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 当缺省集团改为实体集团时 根据集团id删除对应的角色信息，更换和集团相关的tenantId
 */
@ApiModel(description = "当缺省集团改为实体集团时 根据集团id删除对应的角色信息，更换和集团相关的tenantId")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsDeleteRoleUserRelByTenantIdRequest extends MsDoID {
  @JsonProperty("newTenantId")
  private Long newTenantId = null;

  @JsonProperty("oldTenantId")
  private Long oldTenantId = null;

  @JsonProperty("doDeleteFlag")
  private Boolean doDeleteFlag = null;

  @JsonIgnore
  public MsDeleteRoleUserRelByTenantIdRequest newTenantId(Long newTenantId) {
    this.newTenantId = newTenantId;
    return this;
  }

   /**
   * new租户id
   * @return newTenantId
  **/
  @ApiModelProperty(value = "new租户id")
  public Long getNewTenantId() {
    return newTenantId;
  }

  public void setNewTenantId(Long newTenantId) {
    this.newTenantId = newTenantId;
  }

  @JsonIgnore
  public MsDeleteRoleUserRelByTenantIdRequest oldTenantId(Long oldTenantId) {
    this.oldTenantId = oldTenantId;
    return this;
  }

   /**
   * old租户id
   * @return oldTenantId
  **/
  @ApiModelProperty(value = "old租户id")
  public Long getOldTenantId() {
    return oldTenantId;
  }

  public void setOldTenantId(Long oldTenantId) {
    this.oldTenantId = oldTenantId;
  }

  @JsonIgnore
  public MsDeleteRoleUserRelByTenantIdRequest doDeleteFlag(Boolean doDeleteFlag) {
    this.doDeleteFlag = doDeleteFlag;
    return this;
  }

   /**
   * 是否删除old租户对应的数据 true：删除 false：更新
   * @return doDeleteFlag
  **/
  @ApiModelProperty(value = "是否删除old租户对应的数据 true：删除 false：更新")
  public Boolean getDoDeleteFlag() {
    return doDeleteFlag;
  }

  public void setDoDeleteFlag(Boolean doDeleteFlag) {
    this.doDeleteFlag = doDeleteFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsDeleteRoleUserRelByTenantIdRequest deleteRoleUserRelByTenantIdRequest = (MsDeleteRoleUserRelByTenantIdRequest) o;
    return Objects.equals(this.newTenantId, deleteRoleUserRelByTenantIdRequest.newTenantId) &&
        Objects.equals(this.oldTenantId, deleteRoleUserRelByTenantIdRequest.oldTenantId) &&
        Objects.equals(this.doDeleteFlag, deleteRoleUserRelByTenantIdRequest.doDeleteFlag) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(newTenantId, oldTenantId, doDeleteFlag, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsDeleteRoleUserRelByTenantIdRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    newTenantId: ").append(toIndentedString(newTenantId)).append("\n");
    sb.append("    oldTenantId: ").append(toIndentedString(oldTenantId)).append("\n");
    sb.append("    doDeleteFlag: ").append(toIndentedString(doDeleteFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
