package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 操作请求
 */
@ApiModel(description = "操作请求")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsDoBase {
  @JsonProperty("operaterid")
  private String operaterid = null;

  @JsonProperty("operater")
  private String operater = null;

/**
 * 操作类型
 */
  public enum DoTypeEnum {
    I,
    U,
    D
  }
  @JsonProperty("doType")
  private DoTypeEnum doType = null;

  @JsonIgnore
  public MsDoBase operaterid(String operaterid) {
    this.operaterid = operaterid;
    return this;
  }

   /**
   * 操作人ID
   * @return operaterid
  **/
  @ApiModelProperty(value = "操作人ID")
  public String getOperaterid() {
    return operaterid;
  }

  public void setOperaterid(String operaterid) {
    this.operaterid = operaterid;
  }

  @JsonIgnore
  public MsDoBase operater(String operater) {
    this.operater = operater;
    return this;
  }

   /**
   * 操作人
   * @return operater
  **/
  @ApiModelProperty(value = "操作人")
  public String getOperater() {
    return operater;
  }

  public void setOperater(String operater) {
    this.operater = operater;
  }

  @JsonIgnore
  public MsDoBase doType(DoTypeEnum doType) {
    this.doType = doType;
    return this;
  }

   /**
   * 操作类型
   * @return doType
  **/
  @ApiModelProperty(value = "操作类型")
  public DoTypeEnum getDoType() {
    return doType;
  }

  public void setDoType(DoTypeEnum doType) {
    this.doType = doType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsDoBase doBase = (MsDoBase) o;
    return Objects.equals(this.operaterid, doBase.operaterid) &&
        Objects.equals(this.operater, doBase.operater) &&
        Objects.equals(this.doType, doBase.doType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(operaterid, operater, doType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsDoBase {\n");
    
    sb.append("    operaterid: ").append(toIndentedString(operaterid)).append("\n");
    sb.append("    operater: ").append(toIndentedString(operater)).append("\n");
    sb.append("    doType: ").append(toIndentedString(doType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
