package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 操作请求 I新增, U修改, S更新状态, N更新节点归属,F更新不同组织树节点归属,D删除操作
 */
@ApiModel(description = "操作请求 I新增, U修改, S更新状态, N更新节点归属,F更新不同组织树节点归属,D删除操作")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsDoIUSNFD {
  @JsonProperty("operaterid")
  private String operaterid = null;

  @JsonProperty("operater")
  private String operater = null;

/**
 * 操作类型
 */
  public enum DoTypeEnum {
    I,
    U,
    S,
    N,
    F,
    D
  }
  @JsonProperty("doType")
  private DoTypeEnum doType = null;

  @JsonIgnore
  public MsDoIUSNFD operaterid(String operaterid) {
    this.operaterid = operaterid;
    return this;
  }

   /**
   * 操作人ID
   * @return operaterid
  **/
  @ApiModelProperty(value = "操作人ID")
  public String getOperaterid() {
    return operaterid;
  }

  public void setOperaterid(String operaterid) {
    this.operaterid = operaterid;
  }

  @JsonIgnore
  public MsDoIUSNFD operater(String operater) {
    this.operater = operater;
    return this;
  }

   /**
   * 操作人
   * @return operater
  **/
  @ApiModelProperty(value = "操作人")
  public String getOperater() {
    return operater;
  }

  public void setOperater(String operater) {
    this.operater = operater;
  }

  @JsonIgnore
  public MsDoIUSNFD doType(DoTypeEnum doType) {
    this.doType = doType;
    return this;
  }

   /**
   * 操作类型
   * @return doType
  **/
  @ApiModelProperty(value = "操作类型")
  public DoTypeEnum getDoType() {
    return doType;
  }

  public void setDoType(DoTypeEnum doType) {
    this.doType = doType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsDoIUSNFD doIUSNFD = (MsDoIUSNFD) o;
    return Objects.equals(this.operaterid, doIUSNFD.operaterid) &&
        Objects.equals(this.operater, doIUSNFD.operater) &&
        Objects.equals(this.doType, doIUSNFD.doType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(operaterid, operater, doType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsDoIUSNFD {\n");
    
    sb.append("    operaterid: ").append(toIndentedString(operaterid)).append("\n");
    sb.append("    operater: ").append(toIndentedString(operater)).append("\n");
    sb.append("    doType: ").append(toIndentedString(doType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
