package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetAccountListRequest {
  @JsonProperty("page")
  private Integer page = null;

  @JsonProperty("row")
  private Integer row = null;

  @JsonProperty("emailOrPhone")
  private String emailOrPhone = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonIgnore
  public MsGetAccountListRequest page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * 当前页
   * @return page
  **/
  @ApiModelProperty(value = "当前页")
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  @JsonIgnore
  public MsGetAccountListRequest row(Integer row) {
    this.row = row;
    return this;
  }

   /**
   * 每页显示行数
   * @return row
  **/
  @ApiModelProperty(value = "每页显示行数")
  public Integer getRow() {
    return row;
  }

  public void setRow(Integer row) {
    this.row = row;
  }

  @JsonIgnore
  public MsGetAccountListRequest emailOrPhone(String emailOrPhone) {
    this.emailOrPhone = emailOrPhone;
    return this;
  }

   /**
   * 手机|邮箱
   * @return emailOrPhone
  **/
  @ApiModelProperty(value = "手机|邮箱")
  public String getEmailOrPhone() {
    return emailOrPhone;
  }

  public void setEmailOrPhone(String emailOrPhone) {
    this.emailOrPhone = emailOrPhone;
  }

  @JsonIgnore
  public MsGetAccountListRequest status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 启用状态
   * @return status
  **/
  @ApiModelProperty(value = "启用状态")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetAccountListRequest getAccountListRequest = (MsGetAccountListRequest) o;
    return Objects.equals(this.page, getAccountListRequest.page) &&
        Objects.equals(this.row, getAccountListRequest.row) &&
        Objects.equals(this.emailOrPhone, getAccountListRequest.emailOrPhone) &&
        Objects.equals(this.status, getAccountListRequest.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(page, row, emailOrPhone, status);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetAccountListRequest {\n");
    
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    row: ").append(toIndentedString(row)).append("\n");
    sb.append("    emailOrPhone: ").append(toIndentedString(emailOrPhone)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
