package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetOpenApiUserDetailRequest {
  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("userCode")
  private String userCode = null;

  @JsonIgnore
  public MsGetOpenApiUserDetailRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户ID
   * @return userId
  **/
  @ApiModelProperty(value = "用户ID")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsGetOpenApiUserDetailRequest userCode(String userCode) {
    this.userCode = userCode;
    return this;
  }

   /**
   * 用户Code
   * @return userCode
  **/
  @ApiModelProperty(value = "用户Code")
  public String getUserCode() {
    return userCode;
  }

  public void setUserCode(String userCode) {
    this.userCode = userCode;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetOpenApiUserDetailRequest getOpenApiUserDetailRequest = (MsGetOpenApiUserDetailRequest) o;
    return Objects.equals(this.userId, getOpenApiUserDetailRequest.userId) &&
        Objects.equals(this.userCode, getOpenApiUserDetailRequest.userCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userId, userCode);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetOpenApiUserDetailRequest {\n");
    
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    userCode: ").append(toIndentedString(userCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
