package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetOpenApiUserListRequest {
  @JsonProperty("page")
  private Integer page = null;

  @JsonProperty("row")
  private Integer row = null;

  @JsonProperty("userCode")
  private String userCode = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("openapiUserObject")
  private String openapiUserObject = null;

  @JsonIgnore
  public MsGetOpenApiUserListRequest page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * 当前页
   * @return page
  **/
  @ApiModelProperty(value = "当前页")
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  @JsonIgnore
  public MsGetOpenApiUserListRequest row(Integer row) {
    this.row = row;
    return this;
  }

   /**
   * 每页显示行数
   * @return row
  **/
  @ApiModelProperty(value = "每页显示行数")
  public Integer getRow() {
    return row;
  }

  public void setRow(Integer row) {
    this.row = row;
  }

  @JsonIgnore
  public MsGetOpenApiUserListRequest userCode(String userCode) {
    this.userCode = userCode;
    return this;
  }

   /**
   * 用户编码
   * @return userCode
  **/
  @ApiModelProperty(value = "用户编码")
  public String getUserCode() {
    return userCode;
  }

  public void setUserCode(String userCode) {
    this.userCode = userCode;
  }

  @JsonIgnore
  public MsGetOpenApiUserListRequest status(String status) {
    this.status = status;
    return this;
  }

   /**
   * 用户状态
   * @return status
  **/
  @ApiModelProperty(value = "用户状态")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  @JsonIgnore
  public MsGetOpenApiUserListRequest openapiUserObject(String openapiUserObject) {
    this.openapiUserObject = openapiUserObject;
    return this;
  }

   /**
   * openApi用户对象
   * @return openapiUserObject
  **/
  @ApiModelProperty(value = "openApi用户对象")
  public String getOpenapiUserObject() {
    return openapiUserObject;
  }

  public void setOpenapiUserObject(String openapiUserObject) {
    this.openapiUserObject = openapiUserObject;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetOpenApiUserListRequest getOpenApiUserListRequest = (MsGetOpenApiUserListRequest) o;
    return Objects.equals(this.page, getOpenApiUserListRequest.page) &&
        Objects.equals(this.row, getOpenApiUserListRequest.row) &&
        Objects.equals(this.userCode, getOpenApiUserListRequest.userCode) &&
        Objects.equals(this.status, getOpenApiUserListRequest.status) &&
        Objects.equals(this.openapiUserObject, getOpenApiUserListRequest.openapiUserObject);
  }

  @Override
  public int hashCode() {
    return Objects.hash(page, row, userCode, status, openapiUserObject);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetOpenApiUserListRequest {\n");
    
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    row: ").append(toIndentedString(row)).append("\n");
    sb.append("    userCode: ").append(toIndentedString(userCode)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    openapiUserObject: ").append(toIndentedString(openapiUserObject)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
