package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetOrgStructDetailRequest {
  @JsonProperty("orgStructId")
  private Long orgStructId = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("parentId")
  private Long parentId = null;

  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("orgName")
  private String orgName = null;

  @JsonProperty("orgCode")
  private String orgCode = null;

  @JsonProperty("checkParamFlag")
  private Boolean checkParamFlag = null;

  @JsonIgnore
  public MsGetOrgStructDetailRequest orgStructId(Long orgStructId) {
    this.orgStructId = orgStructId;
    return this;
  }

   /**
   * ID
   * @return orgStructId
  **/
  @ApiModelProperty(value = "ID")
  public Long getOrgStructId() {
    return orgStructId;
  }

  public void setOrgStructId(Long orgStructId) {
    this.orgStructId = orgStructId;
  }

  @JsonIgnore
  public MsGetOrgStructDetailRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * tenantId
   * @return tenantId
  **/
  @ApiModelProperty(value = "tenantId")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsGetOrgStructDetailRequest parentId(Long parentId) {
    this.parentId = parentId;
    return this;
  }

   /**
   * parentId
   * @return parentId
  **/
  @ApiModelProperty(value = "parentId")
  public Long getParentId() {
    return parentId;
  }

  public void setParentId(Long parentId) {
    this.parentId = parentId;
  }

  @JsonIgnore
  public MsGetOrgStructDetailRequest companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * companyId
   * @return companyId
  **/
  @ApiModelProperty(value = "companyId")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsGetOrgStructDetailRequest orgName(String orgName) {
    this.orgName = orgName;
    return this;
  }

   /**
   * 组织机构名称
   * @return orgName
  **/
  @ApiModelProperty(value = "组织机构名称")
  public String getOrgName() {
    return orgName;
  }

  public void setOrgName(String orgName) {
    this.orgName = orgName;
  }

  @JsonIgnore
  public MsGetOrgStructDetailRequest orgCode(String orgCode) {
    this.orgCode = orgCode;
    return this;
  }

   /**
   * 组织机构代码
   * @return orgCode
  **/
  @ApiModelProperty(value = "组织机构代码")
  public String getOrgCode() {
    return orgCode;
  }

  public void setOrgCode(String orgCode) {
    this.orgCode = orgCode;
  }

  @JsonIgnore
  public MsGetOrgStructDetailRequest checkParamFlag(Boolean checkParamFlag) {
    this.checkParamFlag = checkParamFlag;
    return this;
  }

   /**
   * 是否是名称/其他 参数验证
   * @return checkParamFlag
  **/
  @ApiModelProperty(value = "是否是名称/其他 参数验证")
  public Boolean getCheckParamFlag() {
    return checkParamFlag;
  }

  public void setCheckParamFlag(Boolean checkParamFlag) {
    this.checkParamFlag = checkParamFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetOrgStructDetailRequest getOrgStructDetailRequest = (MsGetOrgStructDetailRequest) o;
    return Objects.equals(this.orgStructId, getOrgStructDetailRequest.orgStructId) &&
        Objects.equals(this.tenantId, getOrgStructDetailRequest.tenantId) &&
        Objects.equals(this.parentId, getOrgStructDetailRequest.parentId) &&
        Objects.equals(this.companyId, getOrgStructDetailRequest.companyId) &&
        Objects.equals(this.orgName, getOrgStructDetailRequest.orgName) &&
        Objects.equals(this.orgCode, getOrgStructDetailRequest.orgCode) &&
        Objects.equals(this.checkParamFlag, getOrgStructDetailRequest.checkParamFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(orgStructId, tenantId, parentId, companyId, orgName, orgCode, checkParamFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetOrgStructDetailRequest {\n");
    
    sb.append("    orgStructId: ").append(toIndentedString(orgStructId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    parentId: ").append(toIndentedString(parentId)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    orgName: ").append(toIndentedString(orgName)).append("\n");
    sb.append("    orgCode: ").append(toIndentedString(orgCode)).append("\n");
    sb.append("    checkParamFlag: ").append(toIndentedString(checkParamFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
