package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetOrgStructTreeRequest {
  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("excludeCompanyId")
  private Long excludeCompanyId = null;

  @JsonIgnore
  public MsGetOrgStructTreeRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsGetOrgStructTreeRequest status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * org 启用状态
   * @return status
  **/
  @ApiModelProperty(value = "org 启用状态")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsGetOrgStructTreeRequest excludeCompanyId(Long excludeCompanyId) {
    this.excludeCompanyId = excludeCompanyId;
    return this;
  }

   /**
   * 查询排除公司id
   * @return excludeCompanyId
  **/
  @ApiModelProperty(value = "查询排除公司id")
  public Long getExcludeCompanyId() {
    return excludeCompanyId;
  }

  public void setExcludeCompanyId(Long excludeCompanyId) {
    this.excludeCompanyId = excludeCompanyId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetOrgStructTreeRequest getOrgStructTreeRequest = (MsGetOrgStructTreeRequest) o;
    return Objects.equals(this.tenantId, getOrgStructTreeRequest.tenantId) &&
        Objects.equals(this.status, getOrgStructTreeRequest.status) &&
        Objects.equals(this.excludeCompanyId, getOrgStructTreeRequest.excludeCompanyId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantId, status, excludeCompanyId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetOrgStructTreeRequest {\n");
    
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    excludeCompanyId: ").append(toIndentedString(excludeCompanyId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
