package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetResourceApiRelDetailRequest {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("resourceId")
  private Long resourceId = null;

  @JsonProperty("serviceApiId")
  private Long serviceApiId = null;

  @JsonIgnore
  public MsGetResourceApiRelDetailRequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * ID
   * @return id
  **/
  @ApiModelProperty(value = "ID")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsGetResourceApiRelDetailRequest resourceId(Long resourceId) {
    this.resourceId = resourceId;
    return this;
  }

   /**
   * 资源码id
   * @return resourceId
  **/
  @ApiModelProperty(value = "资源码id")
  public Long getResourceId() {
    return resourceId;
  }

  public void setResourceId(Long resourceId) {
    this.resourceId = resourceId;
  }

  @JsonIgnore
  public MsGetResourceApiRelDetailRequest serviceApiId(Long serviceApiId) {
    this.serviceApiId = serviceApiId;
    return this;
  }

   /**
   * 服务 api ID
   * @return serviceApiId
  **/
  @ApiModelProperty(value = "服务 api ID")
  public Long getServiceApiId() {
    return serviceApiId;
  }

  public void setServiceApiId(Long serviceApiId) {
    this.serviceApiId = serviceApiId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetResourceApiRelDetailRequest getResourceApiRelDetailRequest = (MsGetResourceApiRelDetailRequest) o;
    return Objects.equals(this.id, getResourceApiRelDetailRequest.id) &&
        Objects.equals(this.resourceId, getResourceApiRelDetailRequest.resourceId) &&
        Objects.equals(this.serviceApiId, getResourceApiRelDetailRequest.serviceApiId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, resourceId, serviceApiId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetResourceApiRelDetailRequest {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("    serviceApiId: ").append(toIndentedString(serviceApiId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
