package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetResourceListByResourcesetIdRequest {
  @JsonProperty("resourcesetId")
  private Long resourcesetId = null;

  @JsonProperty("page")
  private Integer page = null;

  @JsonProperty("row")
  private Integer row = null;

  @JsonIgnore
  public MsGetResourceListByResourcesetIdRequest resourcesetId(Long resourcesetId) {
    this.resourcesetId = resourcesetId;
    return this;
  }

   /**
   * 功能集Id
   * @return resourcesetId
  **/
  @ApiModelProperty(value = "功能集Id")
  public Long getResourcesetId() {
    return resourcesetId;
  }

  public void setResourcesetId(Long resourcesetId) {
    this.resourcesetId = resourcesetId;
  }

  @JsonIgnore
  public MsGetResourceListByResourcesetIdRequest page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * 当前页
   * @return page
  **/
  @ApiModelProperty(value = "当前页")
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  @JsonIgnore
  public MsGetResourceListByResourcesetIdRequest row(Integer row) {
    this.row = row;
    return this;
  }

   /**
   * 每页显示行数
   * @return row
  **/
  @ApiModelProperty(value = "每页显示行数")
  public Integer getRow() {
    return row;
  }

  public void setRow(Integer row) {
    this.row = row;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetResourceListByResourcesetIdRequest getResourceListByResourcesetIdRequest = (MsGetResourceListByResourcesetIdRequest) o;
    return Objects.equals(this.resourcesetId, getResourceListByResourcesetIdRequest.resourcesetId) &&
        Objects.equals(this.page, getResourceListByResourcesetIdRequest.page) &&
        Objects.equals(this.row, getResourceListByResourcesetIdRequest.row);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resourcesetId, page, row);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetResourceListByResourcesetIdRequest {\n");
    
    sb.append("    resourcesetId: ").append(toIndentedString(resourcesetId)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    row: ").append(toIndentedString(row)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
