package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetRoleDetailRequest {
  @JsonProperty("roleId")
  private Long roleId = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("roleCode")
  private String roleCode = null;

  @JsonProperty("roleName")
  private String roleName = null;

  @JsonIgnore
  public MsGetRoleDetailRequest roleId(Long roleId) {
    this.roleId = roleId;
    return this;
  }

   /**
   * ID
   * @return roleId
  **/
  @ApiModelProperty(value = "ID")
  public Long getRoleId() {
    return roleId;
  }

  public void setRoleId(Long roleId) {
    this.roleId = roleId;
  }

  @JsonIgnore
  public MsGetRoleDetailRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsGetRoleDetailRequest roleCode(String roleCode) {
    this.roleCode = roleCode;
    return this;
  }

   /**
   * 角色编码
   * @return roleCode
  **/
  @ApiModelProperty(value = "角色编码")
  public String getRoleCode() {
    return roleCode;
  }

  public void setRoleCode(String roleCode) {
    this.roleCode = roleCode;
  }

  @JsonIgnore
  public MsGetRoleDetailRequest roleName(String roleName) {
    this.roleName = roleName;
    return this;
  }

   /**
   * 角色名称
   * @return roleName
  **/
  @ApiModelProperty(value = "角色名称")
  public String getRoleName() {
    return roleName;
  }

  public void setRoleName(String roleName) {
    this.roleName = roleName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetRoleDetailRequest getRoleDetailRequest = (MsGetRoleDetailRequest) o;
    return Objects.equals(this.roleId, getRoleDetailRequest.roleId) &&
        Objects.equals(this.tenantId, getRoleDetailRequest.tenantId) &&
        Objects.equals(this.roleCode, getRoleDetailRequest.roleCode) &&
        Objects.equals(this.roleName, getRoleDetailRequest.roleName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(roleId, tenantId, roleCode, roleName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetRoleDetailRequest {\n");
    
    sb.append("    roleId: ").append(toIndentedString(roleId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    roleCode: ").append(toIndentedString(roleCode)).append("\n");
    sb.append("    roleName: ").append(toIndentedString(roleName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
