package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetRoleListByUserIdRequest {
  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("roleKeyWord")
  private String roleKeyWord = null;

  @JsonProperty("isAll")
  private Boolean isAll = null;

  @JsonProperty("page")
  private Integer page = null;

  @JsonProperty("row")
  private Integer row = null;

  @JsonIgnore
  public MsGetRoleListByUserIdRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 人员id
   * @return userId
  **/
  @ApiModelProperty(value = "人员id")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsGetRoleListByUserIdRequest roleKeyWord(String roleKeyWord) {
    this.roleKeyWord = roleKeyWord;
    return this;
  }

   /**
   * code或者name
   * @return roleKeyWord
  **/
  @ApiModelProperty(value = "code或者name")
  public String getRoleKeyWord() {
    return roleKeyWord;
  }

  public void setRoleKeyWord(String roleKeyWord) {
    this.roleKeyWord = roleKeyWord;
  }

  @JsonIgnore
  public MsGetRoleListByUserIdRequest isAll(Boolean isAll) {
    this.isAll = isAll;
    return this;
  }

   /**
   * 是否返回所有(包含超级管理员角色)
   * @return isAll
  **/
  @ApiModelProperty(value = "是否返回所有(包含超级管理员角色)")
  public Boolean getIsAll() {
    return isAll;
  }

  public void setIsAll(Boolean isAll) {
    this.isAll = isAll;
  }

  @JsonIgnore
  public MsGetRoleListByUserIdRequest page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * 当前页
   * @return page
  **/
  @ApiModelProperty(value = "当前页")
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  @JsonIgnore
  public MsGetRoleListByUserIdRequest row(Integer row) {
    this.row = row;
    return this;
  }

   /**
   * 每页显示行数
   * @return row
  **/
  @ApiModelProperty(value = "每页显示行数")
  public Integer getRow() {
    return row;
  }

  public void setRow(Integer row) {
    this.row = row;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetRoleListByUserIdRequest getRoleListByUserIdRequest = (MsGetRoleListByUserIdRequest) o;
    return Objects.equals(this.userId, getRoleListByUserIdRequest.userId) &&
        Objects.equals(this.roleKeyWord, getRoleListByUserIdRequest.roleKeyWord) &&
        Objects.equals(this.isAll, getRoleListByUserIdRequest.isAll) &&
        Objects.equals(this.page, getRoleListByUserIdRequest.page) &&
        Objects.equals(this.row, getRoleListByUserIdRequest.row);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userId, roleKeyWord, isAll, page, row);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetRoleListByUserIdRequest {\n");
    
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    roleKeyWord: ").append(toIndentedString(roleKeyWord)).append("\n");
    sb.append("    isAll: ").append(toIndentedString(isAll)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    row: ").append(toIndentedString(row)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
