package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ucenter.client.model.MsSysRoleDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetRoleListByUserIdResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("total")
  private Long total = null;

  @JsonProperty("result")
  private List<MsSysRoleDTO> result = new ArrayList<MsSysRoleDTO>();

  @JsonIgnore
  public MsGetRoleListByUserIdResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * return code
   * @return code
  **/
  @ApiModelProperty(value = "return code")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsGetRoleListByUserIdResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsGetRoleListByUserIdResponse total(Long total) {
    this.total = total;
    return this;
  }

   /**
   * return total
   * @return total
  **/
  @ApiModelProperty(value = "return total")
  public Long getTotal() {
    return total;
  }

  public void setTotal(Long total) {
    this.total = total;
  }

  @JsonIgnore
  public MsGetRoleListByUserIdResponse result(List<MsSysRoleDTO> result) {
    this.result = result;
    return this;
  }

  public MsGetRoleListByUserIdResponse addResultItem(MsSysRoleDTO resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * 根据userid查询role列表
   * @return result
  **/
  @ApiModelProperty(value = "根据userid查询role列表")
  public List<MsSysRoleDTO> getResult() {
    return result;
  }

  public void setResult(List<MsSysRoleDTO> result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetRoleListByUserIdResponse getRoleListByUserIdResponse = (MsGetRoleListByUserIdResponse) o;
    return Objects.equals(this.code, getRoleListByUserIdResponse.code) &&
        Objects.equals(this.message, getRoleListByUserIdResponse.message) &&
        Objects.equals(this.total, getRoleListByUserIdResponse.total) &&
        Objects.equals(this.result, getRoleListByUserIdResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, total, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetRoleListByUserIdResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
