package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetRoleListRequest {
  @JsonProperty("page")
  private Integer page = null;

  @JsonProperty("row")
  private Integer row = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("tenantId")
  private String tenantId = null;

  @JsonProperty("nameOrCode")
  private String nameOrCode = null;

  @JsonProperty("roleCodes")
  private List<String> roleCodes = new ArrayList<String>();

  @JsonIgnore
  public MsGetRoleListRequest page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * 当前页
   * @return page
  **/
  @ApiModelProperty(value = "当前页")
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  @JsonIgnore
  public MsGetRoleListRequest row(Integer row) {
    this.row = row;
    return this;
  }

   /**
   * 每页显示行数
   * @return row
  **/
  @ApiModelProperty(value = "每页显示行数")
  public Integer getRow() {
    return row;
  }

  public void setRow(Integer row) {
    this.row = row;
  }

  @JsonIgnore
  public MsGetRoleListRequest status(String status) {
    this.status = status;
    return this;
  }

   /**
   * 角色状态
   * @return status
  **/
  @ApiModelProperty(value = "角色状态")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  @JsonIgnore
  public MsGetRoleListRequest tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户Id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户Id")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsGetRoleListRequest nameOrCode(String nameOrCode) {
    this.nameOrCode = nameOrCode;
    return this;
  }

   /**
   * 代码/名称
   * @return nameOrCode
  **/
  @ApiModelProperty(value = "代码/名称")
  public String getNameOrCode() {
    return nameOrCode;
  }

  public void setNameOrCode(String nameOrCode) {
    this.nameOrCode = nameOrCode;
  }

  @JsonIgnore
  public MsGetRoleListRequest roleCodes(List<String> roleCodes) {
    this.roleCodes = roleCodes;
    return this;
  }

  public MsGetRoleListRequest addRoleCodesItem(String roleCodesItem) {
    this.roleCodes.add(roleCodesItem);
    return this;
  }

   /**
   * 角色代码集合
   * @return roleCodes
  **/
  @ApiModelProperty(value = "角色代码集合")
  public List<String> getRoleCodes() {
    return roleCodes;
  }

  public void setRoleCodes(List<String> roleCodes) {
    this.roleCodes = roleCodes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetRoleListRequest getRoleListRequest = (MsGetRoleListRequest) o;
    return Objects.equals(this.page, getRoleListRequest.page) &&
        Objects.equals(this.row, getRoleListRequest.row) &&
        Objects.equals(this.status, getRoleListRequest.status) &&
        Objects.equals(this.tenantId, getRoleListRequest.tenantId) &&
        Objects.equals(this.nameOrCode, getRoleListRequest.nameOrCode) &&
        Objects.equals(this.roleCodes, getRoleListRequest.roleCodes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(page, row, status, tenantId, nameOrCode, roleCodes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetRoleListRequest {\n");
    
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    row: ").append(toIndentedString(row)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    nameOrCode: ").append(toIndentedString(nameOrCode)).append("\n");
    sb.append("    roleCodes: ").append(toIndentedString(roleCodes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
