package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetRoleUserRelListRequest {
  @JsonProperty("relId")
  private Long relId = null;

  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("roleId")
  private Long roleId = null;

  @JsonProperty("page")
  private Integer page = null;

  @JsonProperty("row")
  private Integer row = null;

  @JsonIgnore
  public MsGetRoleUserRelListRequest relId(Long relId) {
    this.relId = relId;
    return this;
  }

   /**
   * 主键id
   * @return relId
  **/
  @ApiModelProperty(value = "主键id")
  public Long getRelId() {
    return relId;
  }

  public void setRelId(Long relId) {
    this.relId = relId;
  }

  @JsonIgnore
  public MsGetRoleUserRelListRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 人员id
   * @return userId
  **/
  @ApiModelProperty(value = "人员id")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsGetRoleUserRelListRequest roleId(Long roleId) {
    this.roleId = roleId;
    return this;
  }

   /**
   * 角色id
   * @return roleId
  **/
  @ApiModelProperty(value = "角色id")
  public Long getRoleId() {
    return roleId;
  }

  public void setRoleId(Long roleId) {
    this.roleId = roleId;
  }

  @JsonIgnore
  public MsGetRoleUserRelListRequest page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * 当前页
   * @return page
  **/
  @ApiModelProperty(value = "当前页")
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  @JsonIgnore
  public MsGetRoleUserRelListRequest row(Integer row) {
    this.row = row;
    return this;
  }

   /**
   * 每页显示行数
   * @return row
  **/
  @ApiModelProperty(value = "每页显示行数")
  public Integer getRow() {
    return row;
  }

  public void setRow(Integer row) {
    this.row = row;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetRoleUserRelListRequest getRoleUserRelListRequest = (MsGetRoleUserRelListRequest) o;
    return Objects.equals(this.relId, getRoleUserRelListRequest.relId) &&
        Objects.equals(this.userId, getRoleUserRelListRequest.userId) &&
        Objects.equals(this.roleId, getRoleUserRelListRequest.roleId) &&
        Objects.equals(this.page, getRoleUserRelListRequest.page) &&
        Objects.equals(this.row, getRoleUserRelListRequest.row);
  }

  @Override
  public int hashCode() {
    return Objects.hash(relId, userId, roleId, page, row);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetRoleUserRelListRequest {\n");
    
    sb.append("    relId: ").append(toIndentedString(relId)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    roleId: ").append(toIndentedString(roleId)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    row: ").append(toIndentedString(row)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
