package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetServiceApiDetailRequest {
  @JsonProperty("resourceId")
  private Long resourceId = null;

  @JsonProperty("serviceApiId")
  private Long serviceApiId = null;

  @JsonProperty("serviceApiName")
  private String serviceApiName = null;

  @JsonProperty("serviceApiUrl")
  private String serviceApiUrl = null;

  @JsonProperty("checkParamFlag")
  private Boolean checkParamFlag = null;

  @JsonIgnore
  public MsGetServiceApiDetailRequest resourceId(Long resourceId) {
    this.resourceId = resourceId;
    return this;
  }

   /**
   * 资源码id
   * @return resourceId
  **/
  @ApiModelProperty(value = "资源码id")
  public Long getResourceId() {
    return resourceId;
  }

  public void setResourceId(Long resourceId) {
    this.resourceId = resourceId;
  }

  @JsonIgnore
  public MsGetServiceApiDetailRequest serviceApiId(Long serviceApiId) {
    this.serviceApiId = serviceApiId;
    return this;
  }

   /**
   * ID
   * @return serviceApiId
  **/
  @ApiModelProperty(value = "ID")
  public Long getServiceApiId() {
    return serviceApiId;
  }

  public void setServiceApiId(Long serviceApiId) {
    this.serviceApiId = serviceApiId;
  }

  @JsonIgnore
  public MsGetServiceApiDetailRequest serviceApiName(String serviceApiName) {
    this.serviceApiName = serviceApiName;
    return this;
  }

   /**
   * Api名称
   * @return serviceApiName
  **/
  @ApiModelProperty(value = "Api名称")
  public String getServiceApiName() {
    return serviceApiName;
  }

  public void setServiceApiName(String serviceApiName) {
    this.serviceApiName = serviceApiName;
  }

  @JsonIgnore
  public MsGetServiceApiDetailRequest serviceApiUrl(String serviceApiUrl) {
    this.serviceApiUrl = serviceApiUrl;
    return this;
  }

   /**
   * Api Url
   * @return serviceApiUrl
  **/
  @ApiModelProperty(value = "Api Url")
  public String getServiceApiUrl() {
    return serviceApiUrl;
  }

  public void setServiceApiUrl(String serviceApiUrl) {
    this.serviceApiUrl = serviceApiUrl;
  }

  @JsonIgnore
  public MsGetServiceApiDetailRequest checkParamFlag(Boolean checkParamFlag) {
    this.checkParamFlag = checkParamFlag;
    return this;
  }

   /**
   * 是否是名称/其他 参数验证
   * @return checkParamFlag
  **/
  @ApiModelProperty(value = "是否是名称/其他 参数验证")
  public Boolean getCheckParamFlag() {
    return checkParamFlag;
  }

  public void setCheckParamFlag(Boolean checkParamFlag) {
    this.checkParamFlag = checkParamFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetServiceApiDetailRequest getServiceApiDetailRequest = (MsGetServiceApiDetailRequest) o;
    return Objects.equals(this.resourceId, getServiceApiDetailRequest.resourceId) &&
        Objects.equals(this.serviceApiId, getServiceApiDetailRequest.serviceApiId) &&
        Objects.equals(this.serviceApiName, getServiceApiDetailRequest.serviceApiName) &&
        Objects.equals(this.serviceApiUrl, getServiceApiDetailRequest.serviceApiUrl) &&
        Objects.equals(this.checkParamFlag, getServiceApiDetailRequest.checkParamFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resourceId, serviceApiId, serviceApiName, serviceApiUrl, checkParamFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetServiceApiDetailRequest {\n");
    
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("    serviceApiId: ").append(toIndentedString(serviceApiId)).append("\n");
    sb.append("    serviceApiName: ").append(toIndentedString(serviceApiName)).append("\n");
    sb.append("    serviceApiUrl: ").append(toIndentedString(serviceApiUrl)).append("\n");
    sb.append("    checkParamFlag: ").append(toIndentedString(checkParamFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
