package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetServiceApiListRequest {
  @JsonProperty("resourceId")
  private Long resourceId = null;

  @JsonProperty("ServiceApiName")
  private String serviceApiName = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("page")
  private Integer page = null;

  @JsonProperty("row")
  private Integer row = null;

  @JsonIgnore
  public MsGetServiceApiListRequest resourceId(Long resourceId) {
    this.resourceId = resourceId;
    return this;
  }

   /**
   * 资源码id
   * @return resourceId
  **/
  @ApiModelProperty(value = "资源码id")
  public Long getResourceId() {
    return resourceId;
  }

  public void setResourceId(Long resourceId) {
    this.resourceId = resourceId;
  }

  @JsonIgnore
  public MsGetServiceApiListRequest serviceApiName(String serviceApiName) {
    this.serviceApiName = serviceApiName;
    return this;
  }

   /**
   * 服务Api名称
   * @return serviceApiName
  **/
  @ApiModelProperty(value = "服务Api名称")
  public String getServiceApiName() {
    return serviceApiName;
  }

  public void setServiceApiName(String serviceApiName) {
    this.serviceApiName = serviceApiName;
  }

  @JsonIgnore
  public MsGetServiceApiListRequest status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 服务Api状态
   * @return status
  **/
  @ApiModelProperty(value = "服务Api状态")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsGetServiceApiListRequest page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * 当前页
   * @return page
  **/
  @ApiModelProperty(value = "当前页")
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  @JsonIgnore
  public MsGetServiceApiListRequest row(Integer row) {
    this.row = row;
    return this;
  }

   /**
   * 每页显示行数
   * @return row
  **/
  @ApiModelProperty(value = "每页显示行数")
  public Integer getRow() {
    return row;
  }

  public void setRow(Integer row) {
    this.row = row;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetServiceApiListRequest getServiceApiListRequest = (MsGetServiceApiListRequest) o;
    return Objects.equals(this.resourceId, getServiceApiListRequest.resourceId) &&
        Objects.equals(this.serviceApiName, getServiceApiListRequest.serviceApiName) &&
        Objects.equals(this.status, getServiceApiListRequest.status) &&
        Objects.equals(this.page, getServiceApiListRequest.page) &&
        Objects.equals(this.row, getServiceApiListRequest.row);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resourceId, serviceApiName, status, page, row);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetServiceApiListRequest {\n");
    
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("    serviceApiName: ").append(toIndentedString(serviceApiName)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    row: ").append(toIndentedString(row)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
