package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetSmsValidCodeDetailRequest {
  @JsonProperty("phone")
  private String phone = null;

  @JsonProperty("loginType")
  private Integer loginType = null;

  @JsonIgnore
  public MsGetSmsValidCodeDetailRequest phone(String phone) {
    this.phone = phone;
    return this;
  }

   /**
   * 手机号码
   * @return phone
  **/
  @ApiModelProperty(value = "手机号码")
  public String getPhone() {
    return phone;
  }

  public void setPhone(String phone) {
    this.phone = phone;
  }

  @JsonIgnore
  public MsGetSmsValidCodeDetailRequest loginType(Integer loginType) {
    this.loginType = loginType;
    return this;
  }

   /**
   * 登录类型 1登录错误类型 2发送验证码错误类型（记录同一账号发送次数）
   * @return loginType
  **/
  @ApiModelProperty(value = "登录类型 1登录错误类型 2发送验证码错误类型（记录同一账号发送次数）")
  public Integer getLoginType() {
    return loginType;
  }

  public void setLoginType(Integer loginType) {
    this.loginType = loginType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetSmsValidCodeDetailRequest getSmsValidCodeDetailRequest = (MsGetSmsValidCodeDetailRequest) o;
    return Objects.equals(this.phone, getSmsValidCodeDetailRequest.phone) &&
        Objects.equals(this.loginType, getSmsValidCodeDetailRequest.loginType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(phone, loginType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetSmsValidCodeDetailRequest {\n");
    
    sb.append("    phone: ").append(toIndentedString(phone)).append("\n");
    sb.append("    loginType: ").append(toIndentedString(loginType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
