package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetUserDetailRequest {
  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("accountId")
  private Long accountId = null;

  @JsonProperty("userPhone")
  private String userPhone = null;

  @JsonProperty("userEmailAddr")
  private String userEmailAddr = null;

  @JsonProperty("enableIdCheck")
  private Boolean enableIdCheck = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("queryAccountNumFlag")
  private Boolean queryAccountNumFlag = null;

  @JsonProperty("queryUserTag")
  private Boolean queryUserTag = null;

  @JsonProperty("userCode")
  private String userCode = null;

  @JsonIgnore
  public MsGetUserDetailRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * ID
   * @return userId
  **/
  @ApiModelProperty(value = "ID")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsGetUserDetailRequest accountId(Long accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * Account ID
   * @return accountId
  **/
  @ApiModelProperty(value = "Account ID")
  public Long getAccountId() {
    return accountId;
  }

  public void setAccountId(Long accountId) {
    this.accountId = accountId;
  }

  @JsonIgnore
  public MsGetUserDetailRequest userPhone(String userPhone) {
    this.userPhone = userPhone;
    return this;
  }

   /**
   * 用户手机号
   * @return userPhone
  **/
  @ApiModelProperty(value = "用户手机号")
  public String getUserPhone() {
    return userPhone;
  }

  public void setUserPhone(String userPhone) {
    this.userPhone = userPhone;
  }

  @JsonIgnore
  public MsGetUserDetailRequest userEmailAddr(String userEmailAddr) {
    this.userEmailAddr = userEmailAddr;
    return this;
  }

   /**
   * 用户邮箱
   * @return userEmailAddr
  **/
  @ApiModelProperty(value = "用户邮箱")
  public String getUserEmailAddr() {
    return userEmailAddr;
  }

  public void setUserEmailAddr(String userEmailAddr) {
    this.userEmailAddr = userEmailAddr;
  }

  @JsonIgnore
  public MsGetUserDetailRequest enableIdCheck(Boolean enableIdCheck) {
    this.enableIdCheck = enableIdCheck;
    return this;
  }

   /**
   * 开启Id验证,默认不开启，用户修改时才开启
   * @return enableIdCheck
  **/
  @ApiModelProperty(value = "开启Id验证,默认不开启，用户修改时才开启")
  public Boolean getEnableIdCheck() {
    return enableIdCheck;
  }

  public void setEnableIdCheck(Boolean enableIdCheck) {
    this.enableIdCheck = enableIdCheck;
  }

  @JsonIgnore
  public MsGetUserDetailRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsGetUserDetailRequest queryAccountNumFlag(Boolean queryAccountNumFlag) {
    this.queryAccountNumFlag = queryAccountNumFlag;
    return this;
  }

   /**
   * 查询账号
   * @return queryAccountNumFlag
  **/
  @ApiModelProperty(value = "查询账号")
  public Boolean getQueryAccountNumFlag() {
    return queryAccountNumFlag;
  }

  public void setQueryAccountNumFlag(Boolean queryAccountNumFlag) {
    this.queryAccountNumFlag = queryAccountNumFlag;
  }

  @JsonIgnore
  public MsGetUserDetailRequest queryUserTag(Boolean queryUserTag) {
    this.queryUserTag = queryUserTag;
    return this;
  }

   /**
   * 查询用户标签
   * @return queryUserTag
  **/
  @ApiModelProperty(value = "查询用户标签")
  public Boolean getQueryUserTag() {
    return queryUserTag;
  }

  public void setQueryUserTag(Boolean queryUserTag) {
    this.queryUserTag = queryUserTag;
  }

  @JsonIgnore
  public MsGetUserDetailRequest userCode(String userCode) {
    this.userCode = userCode;
    return this;
  }

   /**
   * 用户编号
   * @return userCode
  **/
  @ApiModelProperty(value = "用户编号")
  public String getUserCode() {
    return userCode;
  }

  public void setUserCode(String userCode) {
    this.userCode = userCode;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetUserDetailRequest getUserDetailRequest = (MsGetUserDetailRequest) o;
    return Objects.equals(this.userId, getUserDetailRequest.userId) &&
        Objects.equals(this.accountId, getUserDetailRequest.accountId) &&
        Objects.equals(this.userPhone, getUserDetailRequest.userPhone) &&
        Objects.equals(this.userEmailAddr, getUserDetailRequest.userEmailAddr) &&
        Objects.equals(this.enableIdCheck, getUserDetailRequest.enableIdCheck) &&
        Objects.equals(this.tenantId, getUserDetailRequest.tenantId) &&
        Objects.equals(this.queryAccountNumFlag, getUserDetailRequest.queryAccountNumFlag) &&
        Objects.equals(this.queryUserTag, getUserDetailRequest.queryUserTag) &&
        Objects.equals(this.userCode, getUserDetailRequest.userCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userId, accountId, userPhone, userEmailAddr, enableIdCheck, tenantId, queryAccountNumFlag, queryUserTag, userCode);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetUserDetailRequest {\n");
    
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    userPhone: ").append(toIndentedString(userPhone)).append("\n");
    sb.append("    userEmailAddr: ").append(toIndentedString(userEmailAddr)).append("\n");
    sb.append("    enableIdCheck: ").append(toIndentedString(enableIdCheck)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    queryAccountNumFlag: ").append(toIndentedString(queryAccountNumFlag)).append("\n");
    sb.append("    queryUserTag: ").append(toIndentedString(queryUserTag)).append("\n");
    sb.append("    userCode: ").append(toIndentedString(userCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
