package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetUserDetailsByOptionsRequest {
  @JsonProperty("userOptions")
  private String userOptions = null;

  @JsonProperty("tenantId")
  private String tenantId = null;

  @JsonProperty("page")
  private Integer page = null;

  @JsonProperty("row")
  private Integer row = null;

  @JsonIgnore
  public MsGetUserDetailsByOptionsRequest userOptions(String userOptions) {
    this.userOptions = userOptions;
    return this;
  }

   /**
   * Get userOptions
   * @return userOptions
  **/
  @ApiModelProperty(value = "")
  public String getUserOptions() {
    return userOptions;
  }

  public void setUserOptions(String userOptions) {
    this.userOptions = userOptions;
  }

  @JsonIgnore
  public MsGetUserDetailsByOptionsRequest tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * Get tenantId
   * @return tenantId
  **/
  @ApiModelProperty(value = "")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsGetUserDetailsByOptionsRequest page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * 当前页
   * @return page
  **/
  @ApiModelProperty(value = "当前页")
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  @JsonIgnore
  public MsGetUserDetailsByOptionsRequest row(Integer row) {
    this.row = row;
    return this;
  }

   /**
   * 每页显示行数
   * @return row
  **/
  @ApiModelProperty(value = "每页显示行数")
  public Integer getRow() {
    return row;
  }

  public void setRow(Integer row) {
    this.row = row;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetUserDetailsByOptionsRequest getUserDetailsByOptionsRequest = (MsGetUserDetailsByOptionsRequest) o;
    return Objects.equals(this.userOptions, getUserDetailsByOptionsRequest.userOptions) &&
        Objects.equals(this.tenantId, getUserDetailsByOptionsRequest.tenantId) &&
        Objects.equals(this.page, getUserDetailsByOptionsRequest.page) &&
        Objects.equals(this.row, getUserDetailsByOptionsRequest.row);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userOptions, tenantId, page, row);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetUserDetailsByOptionsRequest {\n");
    
    sb.append("    userOptions: ").append(toIndentedString(userOptions)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    row: ").append(toIndentedString(row)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
