package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetUserGroupListRequest {
  @JsonProperty("page")
  private Integer page = null;

  @JsonProperty("row")
  private Integer row = null;

  @JsonProperty("userGroupName")
  private String userGroupName = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("userGroupCode")
  private String userGroupCode = null;

  @JsonIgnore
  public MsGetUserGroupListRequest page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * 当前页
   * @return page
  **/
  @ApiModelProperty(value = "当前页")
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  @JsonIgnore
  public MsGetUserGroupListRequest row(Integer row) {
    this.row = row;
    return this;
  }

   /**
   * 每页显示行数
   * @return row
  **/
  @ApiModelProperty(value = "每页显示行数")
  public Integer getRow() {
    return row;
  }

  public void setRow(Integer row) {
    this.row = row;
  }

  @JsonIgnore
  public MsGetUserGroupListRequest userGroupName(String userGroupName) {
    this.userGroupName = userGroupName;
    return this;
  }

   /**
   * 用户组名称
   * @return userGroupName
  **/
  @ApiModelProperty(value = "用户组名称")
  public String getUserGroupName() {
    return userGroupName;
  }

  public void setUserGroupName(String userGroupName) {
    this.userGroupName = userGroupName;
  }

  @JsonIgnore
  public MsGetUserGroupListRequest status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 用户组状态
   * @return status
  **/
  @ApiModelProperty(value = "用户组状态")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsGetUserGroupListRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户Id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户Id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsGetUserGroupListRequest userGroupCode(String userGroupCode) {
    this.userGroupCode = userGroupCode;
    return this;
  }

   /**
   * 用户组代码
   * @return userGroupCode
  **/
  @ApiModelProperty(value = "用户组代码")
  public String getUserGroupCode() {
    return userGroupCode;
  }

  public void setUserGroupCode(String userGroupCode) {
    this.userGroupCode = userGroupCode;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetUserGroupListRequest getUserGroupListRequest = (MsGetUserGroupListRequest) o;
    return Objects.equals(this.page, getUserGroupListRequest.page) &&
        Objects.equals(this.row, getUserGroupListRequest.row) &&
        Objects.equals(this.userGroupName, getUserGroupListRequest.userGroupName) &&
        Objects.equals(this.status, getUserGroupListRequest.status) &&
        Objects.equals(this.tenantId, getUserGroupListRequest.tenantId) &&
        Objects.equals(this.userGroupCode, getUserGroupListRequest.userGroupCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(page, row, userGroupName, status, tenantId, userGroupCode);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetUserGroupListRequest {\n");
    
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    row: ").append(toIndentedString(row)).append("\n");
    sb.append("    userGroupName: ").append(toIndentedString(userGroupName)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    userGroupCode: ").append(toIndentedString(userGroupCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
