package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetUserListByCompanyIdRequest {
  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("page")
  private Integer page = null;

  @JsonProperty("row")
  private Integer row = null;

  @JsonIgnore
  public MsGetUserListByCompanyIdRequest companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 企业id
   * @return companyId
  **/
  @ApiModelProperty(value = "企业id")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsGetUserListByCompanyIdRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsGetUserListByCompanyIdRequest page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * 当前页
   * @return page
  **/
  @ApiModelProperty(value = "当前页")
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  @JsonIgnore
  public MsGetUserListByCompanyIdRequest row(Integer row) {
    this.row = row;
    return this;
  }

   /**
   * 每页显示行数
   * @return row
  **/
  @ApiModelProperty(value = "每页显示行数")
  public Integer getRow() {
    return row;
  }

  public void setRow(Integer row) {
    this.row = row;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetUserListByCompanyIdRequest getUserListByCompanyIdRequest = (MsGetUserListByCompanyIdRequest) o;
    return Objects.equals(this.companyId, getUserListByCompanyIdRequest.companyId) &&
        Objects.equals(this.tenantId, getUserListByCompanyIdRequest.tenantId) &&
        Objects.equals(this.page, getUserListByCompanyIdRequest.page) &&
        Objects.equals(this.row, getUserListByCompanyIdRequest.row);
  }

  @Override
  public int hashCode() {
    return Objects.hash(companyId, tenantId, page, row);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetUserListByCompanyIdRequest {\n");
    
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    row: ").append(toIndentedString(row)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
