package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetUserListRequest {
  @JsonProperty("status")
  private String status = null;

  @JsonProperty("activeStatus")
  private String activeStatus = null;

  @JsonProperty("userPhone")
  private String userPhone = null;

  @JsonProperty("userEmailAddr")
  private String userEmailAddr = null;

  @JsonProperty("user")
  private String user = null;

  @JsonProperty("accountId")
  private Long accountId = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("page")
  private Integer page = null;

  @JsonProperty("row")
  private Integer row = null;

  @JsonProperty("queryAccountNumFlag")
  private Boolean queryAccountNumFlag = null;

  @JsonIgnore
  public MsGetUserListRequest status(String status) {
    this.status = status;
    return this;
  }

   /**
   * 状态 1:启用  0：停用
   * @return status
  **/
  @ApiModelProperty(value = "状态 1:启用  0：停用")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  @JsonIgnore
  public MsGetUserListRequest activeStatus(String activeStatus) {
    this.activeStatus = activeStatus;
    return this;
  }

   /**
   * 账户状态 1:已激活 0：未激活
   * @return activeStatus
  **/
  @ApiModelProperty(value = "账户状态 1:已激活 0：未激活")
  public String getActiveStatus() {
    return activeStatus;
  }

  public void setActiveStatus(String activeStatus) {
    this.activeStatus = activeStatus;
  }

  @JsonIgnore
  public MsGetUserListRequest userPhone(String userPhone) {
    this.userPhone = userPhone;
    return this;
  }

   /**
   * 手机号码
   * @return userPhone
  **/
  @ApiModelProperty(value = "手机号码")
  public String getUserPhone() {
    return userPhone;
  }

  public void setUserPhone(String userPhone) {
    this.userPhone = userPhone;
  }

  @JsonIgnore
  public MsGetUserListRequest userEmailAddr(String userEmailAddr) {
    this.userEmailAddr = userEmailAddr;
    return this;
  }

   /**
   * 邮箱地址
   * @return userEmailAddr
  **/
  @ApiModelProperty(value = "邮箱地址")
  public String getUserEmailAddr() {
    return userEmailAddr;
  }

  public void setUserEmailAddr(String userEmailAddr) {
    this.userEmailAddr = userEmailAddr;
  }

  @JsonIgnore
  public MsGetUserListRequest user(String user) {
    this.user = user;
    return this;
  }

   /**
   * 人员代码/人员工号/人员名称
   * @return user
  **/
  @ApiModelProperty(value = "人员代码/人员工号/人员名称")
  public String getUser() {
    return user;
  }

  public void setUser(String user) {
    this.user = user;
  }

  @JsonIgnore
  public MsGetUserListRequest accountId(Long accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * 账号id
   * @return accountId
  **/
  @ApiModelProperty(value = "账号id")
  public Long getAccountId() {
    return accountId;
  }

  public void setAccountId(Long accountId) {
    this.accountId = accountId;
  }

  @JsonIgnore
  public MsGetUserListRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsGetUserListRequest page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * 当前页
   * @return page
  **/
  @ApiModelProperty(value = "当前页")
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  @JsonIgnore
  public MsGetUserListRequest row(Integer row) {
    this.row = row;
    return this;
  }

   /**
   * 每页显示行数
   * @return row
  **/
  @ApiModelProperty(value = "每页显示行数")
  public Integer getRow() {
    return row;
  }

  public void setRow(Integer row) {
    this.row = row;
  }

  @JsonIgnore
  public MsGetUserListRequest queryAccountNumFlag(Boolean queryAccountNumFlag) {
    this.queryAccountNumFlag = queryAccountNumFlag;
    return this;
  }

   /**
   * 查询账号
   * @return queryAccountNumFlag
  **/
  @ApiModelProperty(value = "查询账号")
  public Boolean getQueryAccountNumFlag() {
    return queryAccountNumFlag;
  }

  public void setQueryAccountNumFlag(Boolean queryAccountNumFlag) {
    this.queryAccountNumFlag = queryAccountNumFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetUserListRequest getUserListRequest = (MsGetUserListRequest) o;
    return Objects.equals(this.status, getUserListRequest.status) &&
        Objects.equals(this.activeStatus, getUserListRequest.activeStatus) &&
        Objects.equals(this.userPhone, getUserListRequest.userPhone) &&
        Objects.equals(this.userEmailAddr, getUserListRequest.userEmailAddr) &&
        Objects.equals(this.user, getUserListRequest.user) &&
        Objects.equals(this.accountId, getUserListRequest.accountId) &&
        Objects.equals(this.tenantId, getUserListRequest.tenantId) &&
        Objects.equals(this.page, getUserListRequest.page) &&
        Objects.equals(this.row, getUserListRequest.row) &&
        Objects.equals(this.queryAccountNumFlag, getUserListRequest.queryAccountNumFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status, activeStatus, userPhone, userEmailAddr, user, accountId, tenantId, page, row, queryAccountNumFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetUserListRequest {\n");
    
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    activeStatus: ").append(toIndentedString(activeStatus)).append("\n");
    sb.append("    userPhone: ").append(toIndentedString(userPhone)).append("\n");
    sb.append("    userEmailAddr: ").append(toIndentedString(userEmailAddr)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    row: ").append(toIndentedString(row)).append("\n");
    sb.append("    queryAccountNumFlag: ").append(toIndentedString(queryAccountNumFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
