package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetUserOrgStructListRequest {
  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("userId")
  private Long userId = null;

  @JsonIgnore
  public MsGetUserOrgStructListRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsGetUserOrgStructListRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户id
   * @return userId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetUserOrgStructListRequest getUserOrgStructListRequest = (MsGetUserOrgStructListRequest) o;
    return Objects.equals(this.tenantId, getUserOrgStructListRequest.tenantId) &&
        Objects.equals(this.userId, getUserOrgStructListRequest.userId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantId, userId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetUserOrgStructListRequest {\n");
    
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
