package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ucenter.client.model.MsSysOrgStructDTOExt;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetUserOrgStructListResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("currentOrgs")
  private List<MsSysOrgStructDTOExt> currentOrgs = new ArrayList<MsSysOrgStructDTOExt>();

  @JsonProperty("orgs")
  private List<MsSysOrgStructDTOExt> orgs = new ArrayList<MsSysOrgStructDTOExt>();

  @JsonProperty("parentCompanyOrgs")
  private List<MsSysOrgStructDTOExt> parentCompanyOrgs = new ArrayList<MsSysOrgStructDTOExt>();

  @JsonIgnore
  public MsGetUserOrgStructListResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * return code
   * @return code
  **/
  @ApiModelProperty(value = "return code")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsGetUserOrgStructListResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsGetUserOrgStructListResponse currentOrgs(List<MsSysOrgStructDTOExt> currentOrgs) {
    this.currentOrgs = currentOrgs;
    return this;
  }

  public MsGetUserOrgStructListResponse addCurrentOrgsItem(MsSysOrgStructDTOExt currentOrgsItem) {
    this.currentOrgs.add(currentOrgsItem);
    return this;
  }

   /**
   * 所属组织架构信息
   * @return currentOrgs
  **/
  @ApiModelProperty(value = "所属组织架构信息")
  public List<MsSysOrgStructDTOExt> getCurrentOrgs() {
    return currentOrgs;
  }

  public void setCurrentOrgs(List<MsSysOrgStructDTOExt> currentOrgs) {
    this.currentOrgs = currentOrgs;
  }

  @JsonIgnore
  public MsGetUserOrgStructListResponse orgs(List<MsSysOrgStructDTOExt> orgs) {
    this.orgs = orgs;
    return this;
  }

  public MsGetUserOrgStructListResponse addOrgsItem(MsSysOrgStructDTOExt orgsItem) {
    this.orgs.add(orgsItem);
    return this;
  }

   /**
   * 所属组织及子组织架构信息
   * @return orgs
  **/
  @ApiModelProperty(value = "所属组织及子组织架构信息")
  public List<MsSysOrgStructDTOExt> getOrgs() {
    return orgs;
  }

  public void setOrgs(List<MsSysOrgStructDTOExt> orgs) {
    this.orgs = orgs;
  }

  @JsonIgnore
  public MsGetUserOrgStructListResponse parentCompanyOrgs(List<MsSysOrgStructDTOExt> parentCompanyOrgs) {
    this.parentCompanyOrgs = parentCompanyOrgs;
    return this;
  }

  public MsGetUserOrgStructListResponse addParentCompanyOrgsItem(MsSysOrgStructDTOExt parentCompanyOrgsItem) {
    this.parentCompanyOrgs.add(parentCompanyOrgsItem);
    return this;
  }

   /**
   * 最近的上一级公司集合
   * @return parentCompanyOrgs
  **/
  @ApiModelProperty(value = "最近的上一级公司集合")
  public List<MsSysOrgStructDTOExt> getParentCompanyOrgs() {
    return parentCompanyOrgs;
  }

  public void setParentCompanyOrgs(List<MsSysOrgStructDTOExt> parentCompanyOrgs) {
    this.parentCompanyOrgs = parentCompanyOrgs;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetUserOrgStructListResponse getUserOrgStructListResponse = (MsGetUserOrgStructListResponse) o;
    return Objects.equals(this.code, getUserOrgStructListResponse.code) &&
        Objects.equals(this.message, getUserOrgStructListResponse.message) &&
        Objects.equals(this.currentOrgs, getUserOrgStructListResponse.currentOrgs) &&
        Objects.equals(this.orgs, getUserOrgStructListResponse.orgs) &&
        Objects.equals(this.parentCompanyOrgs, getUserOrgStructListResponse.parentCompanyOrgs);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, currentOrgs, orgs, parentCompanyOrgs);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetUserOrgStructListResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    currentOrgs: ").append(toIndentedString(currentOrgs)).append("\n");
    sb.append("    orgs: ").append(toIndentedString(orgs)).append("\n");
    sb.append("    parentCompanyOrgs: ").append(toIndentedString(parentCompanyOrgs)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
