package com.xforceplus.ucenter.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@ApiModel(description = "请求对象")
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsLoginAccountDetailRequest{
  public static final String NOT_NEED = "0";
  public static final String NEED = "1";
  @JsonProperty("needPassword")
  private String needPassword;
  @JsonProperty("username")
  private String username;
  @JsonProperty("password")
  private String password;
  public String getNeedPassword() {
    return needPassword;
  }

  public void setNeedPassword(String needPassword) {
    this.needPassword = needPassword;
  }

  public String getUsername() {
    return username;
  }

  public void setUsername(String username) {
    this.username = username;
  }

  public String getPassword() {
    return password;
  }

  public void setPassword(String password) {
    this.password = password;
  }
}
