package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.ucenter.client.model.MsDoIU;
import com.xforceplus.ucenter.client.model.MsSysIdentiSettingDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 操作人员角色关联信息
 */
@ApiModel(description = "操作人员角色关联信息")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsOperateGroupIdentiRequest extends MsDoIU {
  @JsonProperty("sysIdentiSettingInfo")
  private MsSysIdentiSettingDTO sysIdentiSettingInfo = null;

  @JsonIgnore
  public MsOperateGroupIdentiRequest sysIdentiSettingInfo(MsSysIdentiSettingDTO sysIdentiSettingInfo) {
    this.sysIdentiSettingInfo = sysIdentiSettingInfo;
    return this;
  }

   /**
   * Get sysIdentiSettingInfo
   * @return sysIdentiSettingInfo
  **/
  @ApiModelProperty(value = "")
  public MsSysIdentiSettingDTO getSysIdentiSettingInfo() {
    return sysIdentiSettingInfo;
  }

  public void setSysIdentiSettingInfo(MsSysIdentiSettingDTO sysIdentiSettingInfo) {
    this.sysIdentiSettingInfo = sysIdentiSettingInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOperateGroupIdentiRequest operateGroupIdentiRequest = (MsOperateGroupIdentiRequest) o;
    return Objects.equals(this.sysIdentiSettingInfo, operateGroupIdentiRequest.sysIdentiSettingInfo) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sysIdentiSettingInfo, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOperateGroupIdentiRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    sysIdentiSettingInfo: ").append(toIndentedString(sysIdentiSettingInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
