package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.ucenter.client.model.MsDoIUSNFD;
import com.xforceplus.ucenter.client.model.MsSysMenuDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsOperateMenuRequest extends MsDoIUSNFD {
  @JsonProperty("menuInfo")
  private MsSysMenuDTO menuInfo = null;

  @JsonIgnore
  public MsOperateMenuRequest menuInfo(MsSysMenuDTO menuInfo) {
    this.menuInfo = menuInfo;
    return this;
  }

   /**
   * Get menuInfo
   * @return menuInfo
  **/
  @ApiModelProperty(value = "")
  public MsSysMenuDTO getMenuInfo() {
    return menuInfo;
  }

  public void setMenuInfo(MsSysMenuDTO menuInfo) {
    this.menuInfo = menuInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOperateMenuRequest operateMenuRequest = (MsOperateMenuRequest) o;
    return Objects.equals(this.menuInfo, operateMenuRequest.menuInfo) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(menuInfo, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOperateMenuRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    menuInfo: ").append(toIndentedString(menuInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
