package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.ucenter.client.model.MsDoIUSNFD;
import com.xforceplus.ucenter.client.model.MsSysOrgStructDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsOperateOrgStructRequest extends MsDoIUSNFD {
  @JsonProperty("orgStructInfo")
  private MsSysOrgStructDTO orgStructInfo = null;

  @JsonProperty("parentTenantId")
  private Long parentTenantId = null;

  @JsonIgnore
  public MsOperateOrgStructRequest orgStructInfo(MsSysOrgStructDTO orgStructInfo) {
    this.orgStructInfo = orgStructInfo;
    return this;
  }

   /**
   * Get orgStructInfo
   * @return orgStructInfo
  **/
  @ApiModelProperty(value = "")
  public MsSysOrgStructDTO getOrgStructInfo() {
    return orgStructInfo;
  }

  public void setOrgStructInfo(MsSysOrgStructDTO orgStructInfo) {
    this.orgStructInfo = orgStructInfo;
  }

  @JsonIgnore
  public MsOperateOrgStructRequest parentTenantId(Long parentTenantId) {
    this.parentTenantId = parentTenantId;
    return this;
  }

   /**
   * 移动到的组织id
   * @return parentTenantId
  **/
  @ApiModelProperty(value = "移动到的组织id")
  public Long getParentTenantId() {
    return parentTenantId;
  }

  public void setParentTenantId(Long parentTenantId) {
    this.parentTenantId = parentTenantId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOperateOrgStructRequest operateOrgStructRequest = (MsOperateOrgStructRequest) o;
    return Objects.equals(this.orgStructInfo, operateOrgStructRequest.orgStructInfo) &&
        Objects.equals(this.parentTenantId, operateOrgStructRequest.parentTenantId) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(orgStructInfo, parentTenantId, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOperateOrgStructRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    orgStructInfo: ").append(toIndentedString(orgStructInfo)).append("\n");
    sb.append("    parentTenantId: ").append(toIndentedString(parentTenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
