package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.ucenter.client.model.MsDoBase;
import com.xforceplus.ucenter.client.model.MsSysResourceApiRelDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsOperateResourceApiRelRequest extends MsDoBase {
  @JsonProperty("resourceApiRelInfo")
  private MsSysResourceApiRelDTO resourceApiRelInfo = null;

  @JsonIgnore
  public MsOperateResourceApiRelRequest resourceApiRelInfo(MsSysResourceApiRelDTO resourceApiRelInfo) {
    this.resourceApiRelInfo = resourceApiRelInfo;
    return this;
  }

   /**
   * Get resourceApiRelInfo
   * @return resourceApiRelInfo
  **/
  @ApiModelProperty(value = "")
  public MsSysResourceApiRelDTO getResourceApiRelInfo() {
    return resourceApiRelInfo;
  }

  public void setResourceApiRelInfo(MsSysResourceApiRelDTO resourceApiRelInfo) {
    this.resourceApiRelInfo = resourceApiRelInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOperateResourceApiRelRequest operateResourceApiRelRequest = (MsOperateResourceApiRelRequest) o;
    return Objects.equals(this.resourceApiRelInfo, operateResourceApiRelRequest.resourceApiRelInfo) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resourceApiRelInfo, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOperateResourceApiRelRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    resourceApiRelInfo: ").append(toIndentedString(resourceApiRelInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
