package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.ucenter.client.model.MsDoID;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 操作人员角色关联信息
 */
@ApiModel(description = "操作人员角色关联信息")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsOperateRoleUserRelExtRequest extends MsDoID {
  @JsonProperty("roleId")
  private Long roleId = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("userIds")
  private List<Long> userIds = new ArrayList<Long>();

  @JsonIgnore
  public MsOperateRoleUserRelExtRequest roleId(Long roleId) {
    this.roleId = roleId;
    return this;
  }

   /**
   * 角色id
   * @return roleId
  **/
  @ApiModelProperty(value = "角色id")
  public Long getRoleId() {
    return roleId;
  }

  public void setRoleId(Long roleId) {
    this.roleId = roleId;
  }

  @JsonIgnore
  public MsOperateRoleUserRelExtRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsOperateRoleUserRelExtRequest userIds(List<Long> userIds) {
    this.userIds = userIds;
    return this;
  }

  public MsOperateRoleUserRelExtRequest addUserIdsItem(Long userIdsItem) {
    this.userIds.add(userIdsItem);
    return this;
  }

   /**
   * 用户ids
   * @return userIds
  **/
  @ApiModelProperty(value = "用户ids")
  public List<Long> getUserIds() {
    return userIds;
  }

  public void setUserIds(List<Long> userIds) {
    this.userIds = userIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOperateRoleUserRelExtRequest operateRoleUserRelExtRequest = (MsOperateRoleUserRelExtRequest) o;
    return Objects.equals(this.roleId, operateRoleUserRelExtRequest.roleId) &&
        Objects.equals(this.tenantId, operateRoleUserRelExtRequest.tenantId) &&
        Objects.equals(this.userIds, operateRoleUserRelExtRequest.userIds) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(roleId, tenantId, userIds, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOperateRoleUserRelExtRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    roleId: ").append(toIndentedString(roleId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    userIds: ").append(toIndentedString(userIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
