package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.ucenter.client.model.MsDoID;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 操作人员角色关联信息
 */
@ApiModel(description = "操作人员角色关联信息")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsOperateRoleUserRelRequest extends MsDoID {
  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("roleIds")
  private List<Long> roleIds = new ArrayList<Long>();

  @JsonIgnore
  public MsOperateRoleUserRelRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户id
   * @return userId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsOperateRoleUserRelRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsOperateRoleUserRelRequest roleIds(List<Long> roleIds) {
    this.roleIds = roleIds;
    return this;
  }

  public MsOperateRoleUserRelRequest addRoleIdsItem(Long roleIdsItem) {
    this.roleIds.add(roleIdsItem);
    return this;
  }

   /**
   * 角色ids
   * @return roleIds
  **/
  @ApiModelProperty(value = "角色ids")
  public List<Long> getRoleIds() {
    return roleIds;
  }

  public void setRoleIds(List<Long> roleIds) {
    this.roleIds = roleIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOperateRoleUserRelRequest operateRoleUserRelRequest = (MsOperateRoleUserRelRequest) o;
    return Objects.equals(this.userId, operateRoleUserRelRequest.userId) &&
        Objects.equals(this.tenantId, operateRoleUserRelRequest.tenantId) &&
        Objects.equals(this.roleIds, operateRoleUserRelRequest.roleIds) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userId, tenantId, roleIds, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOperateRoleUserRelRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    roleIds: ").append(toIndentedString(roleIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
