package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.ucenter.client.model.MsDoBase;
import com.xforceplus.ucenter.client.model.MsSysServiceApiDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsOperateServiceApiRequest extends MsDoBase {
  @JsonProperty("resourceId")
  private Long resourceId = null;

  @JsonProperty("serviceApiInfo")
  private MsSysServiceApiDTO serviceApiInfo = null;

  @JsonIgnore
  public MsOperateServiceApiRequest resourceId(Long resourceId) {
    this.resourceId = resourceId;
    return this;
  }

   /**
   * 资源码id
   * @return resourceId
  **/
  @ApiModelProperty(value = "资源码id")
  public Long getResourceId() {
    return resourceId;
  }

  public void setResourceId(Long resourceId) {
    this.resourceId = resourceId;
  }

  @JsonIgnore
  public MsOperateServiceApiRequest serviceApiInfo(MsSysServiceApiDTO serviceApiInfo) {
    this.serviceApiInfo = serviceApiInfo;
    return this;
  }

   /**
   * Get serviceApiInfo
   * @return serviceApiInfo
  **/
  @ApiModelProperty(value = "")
  public MsSysServiceApiDTO getServiceApiInfo() {
    return serviceApiInfo;
  }

  public void setServiceApiInfo(MsSysServiceApiDTO serviceApiInfo) {
    this.serviceApiInfo = serviceApiInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOperateServiceApiRequest operateServiceApiRequest = (MsOperateServiceApiRequest) o;
    return Objects.equals(this.resourceId, operateServiceApiRequest.resourceId) &&
        Objects.equals(this.serviceApiInfo, operateServiceApiRequest.serviceApiInfo) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resourceId, serviceApiInfo, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOperateServiceApiRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("    serviceApiInfo: ").append(toIndentedString(serviceApiInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
