package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.ucenter.client.model.MsDoID;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsOperateUserGroupRelRoleRequest extends MsDoID {
  @JsonProperty("userGroupId")
  private Long userGroupId = null;

  @JsonProperty("roleIds")
  private List<Long> roleIds = new ArrayList<Long>();

  @JsonIgnore
  public MsOperateUserGroupRelRoleRequest userGroupId(Long userGroupId) {
    this.userGroupId = userGroupId;
    return this;
  }

   /**
   * ID
   * @return userGroupId
  **/
  @ApiModelProperty(value = "ID")
  public Long getUserGroupId() {
    return userGroupId;
  }

  public void setUserGroupId(Long userGroupId) {
    this.userGroupId = userGroupId;
  }

  @JsonIgnore
  public MsOperateUserGroupRelRoleRequest roleIds(List<Long> roleIds) {
    this.roleIds = roleIds;
    return this;
  }

  public MsOperateUserGroupRelRoleRequest addRoleIdsItem(Long roleIdsItem) {
    this.roleIds.add(roleIdsItem);
    return this;
  }

   /**
   * 角色ids
   * @return roleIds
  **/
  @ApiModelProperty(value = "角色ids")
  public List<Long> getRoleIds() {
    return roleIds;
  }

  public void setRoleIds(List<Long> roleIds) {
    this.roleIds = roleIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOperateUserGroupRelRoleRequest operateUserGroupRelRoleRequest = (MsOperateUserGroupRelRoleRequest) o;
    return Objects.equals(this.userGroupId, operateUserGroupRelRoleRequest.userGroupId) &&
        Objects.equals(this.roleIds, operateUserGroupRelRoleRequest.roleIds) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userGroupId, roleIds, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOperateUserGroupRelRoleRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    userGroupId: ").append(toIndentedString(userGroupId)).append("\n");
    sb.append("    roleIds: ").append(toIndentedString(roleIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
