package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.ucenter.client.model.MsDoIUSNFD;
import com.xforceplus.ucenter.client.model.MsSysUserGroupDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsOperateUserGroupRequest extends MsDoIUSNFD {
  @JsonProperty("userGroupInfo")
  private MsSysUserGroupDTO userGroupInfo = null;

  @JsonIgnore
  public MsOperateUserGroupRequest userGroupInfo(MsSysUserGroupDTO userGroupInfo) {
    this.userGroupInfo = userGroupInfo;
    return this;
  }

   /**
   * Get userGroupInfo
   * @return userGroupInfo
  **/
  @ApiModelProperty(value = "")
  public MsSysUserGroupDTO getUserGroupInfo() {
    return userGroupInfo;
  }

  public void setUserGroupInfo(MsSysUserGroupDTO userGroupInfo) {
    this.userGroupInfo = userGroupInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOperateUserGroupRequest operateUserGroupRequest = (MsOperateUserGroupRequest) o;
    return Objects.equals(this.userGroupInfo, operateUserGroupRequest.userGroupInfo) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userGroupInfo, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOperateUserGroupRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    userGroupInfo: ").append(toIndentedString(userGroupInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
