package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysLogDTO {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("tableName")
  private String tableName = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("identityId")
  private Long identityId = null;

  @JsonProperty("actionCode")
  private String actionCode = null;

  @JsonProperty("resultMsg")
  private String resultMsg = null;

  @JsonProperty("createUserId")
  private String createUserId = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonIgnore
  public MsSysLogDTO id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键ID
   * @return id
  **/
  @ApiModelProperty(value = "主键ID")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsSysLogDTO tableName(String tableName) {
    this.tableName = tableName;
    return this;
  }

   /**
   * 表名
   * @return tableName
  **/
  @ApiModelProperty(value = "表名")
  public String getTableName() {
    return tableName;
  }

  public void setTableName(String tableName) {
    this.tableName = tableName;
  }

  @JsonIgnore
  public MsSysLogDTO tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsSysLogDTO identityId(Long identityId) {
    this.identityId = identityId;
    return this;
  }

   /**
   * 操作主键ID
   * @return identityId
  **/
  @ApiModelProperty(value = "操作主键ID")
  public Long getIdentityId() {
    return identityId;
  }

  public void setIdentityId(Long identityId) {
    this.identityId = identityId;
  }

  @JsonIgnore
  public MsSysLogDTO actionCode(String actionCode) {
    this.actionCode = actionCode;
    return this;
  }

   /**
   * 操作类型:I U D
   * @return actionCode
  **/
  @ApiModelProperty(value = "操作类型:I U D")
  public String getActionCode() {
    return actionCode;
  }

  public void setActionCode(String actionCode) {
    this.actionCode = actionCode;
  }

  @JsonIgnore
  public MsSysLogDTO resultMsg(String resultMsg) {
    this.resultMsg = resultMsg;
    return this;
  }

   /**
   * 操作描述：json格式相关数据
   * @return resultMsg
  **/
  @ApiModelProperty(value = "操作描述：json格式相关数据")
  public String getResultMsg() {
    return resultMsg;
  }

  public void setResultMsg(String resultMsg) {
    this.resultMsg = resultMsg;
  }

  @JsonIgnore
  public MsSysLogDTO createUserId(String createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建人ID
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建人ID")
  public String getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public MsSysLogDTO createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public MsSysLogDTO createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysLogDTO sysLogDTO = (MsSysLogDTO) o;
    return Objects.equals(this.id, sysLogDTO.id) &&
        Objects.equals(this.tableName, sysLogDTO.tableName) &&
        Objects.equals(this.tenantId, sysLogDTO.tenantId) &&
        Objects.equals(this.identityId, sysLogDTO.identityId) &&
        Objects.equals(this.actionCode, sysLogDTO.actionCode) &&
        Objects.equals(this.resultMsg, sysLogDTO.resultMsg) &&
        Objects.equals(this.createUserId, sysLogDTO.createUserId) &&
        Objects.equals(this.createUserName, sysLogDTO.createUserName) &&
        Objects.equals(this.createTime, sysLogDTO.createTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, tableName, tenantId, identityId, actionCode, resultMsg, createUserId, createUserName, createTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysLogDTO {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    tableName: ").append(toIndentedString(tableName)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    identityId: ").append(toIndentedString(identityId)).append("\n");
    sb.append("    actionCode: ").append(toIndentedString(actionCode)).append("\n");
    sb.append("    resultMsg: ").append(toIndentedString(resultMsg)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
