package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysMenuInfo {
  @JsonProperty("menuId")
  private Long menuId = null;

  @JsonProperty("menuName")
  private String menuName = null;

  @JsonProperty("menuUrl")
  private String menuUrl = null;

  @JsonProperty("parentId")
  private Long parentId = null;

  @JsonProperty("menuOrder")
  private Long menuOrder = null;

  @JsonProperty("menuDesc")
  private String menuDesc = null;

  @JsonProperty("resourceCode")
  private String resourceCode = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("statusTime")
  private String statusTime = null;

  @JsonProperty("createUserId")
  private String createUserId = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("updateUserId")
  private String updateUserId = null;

  @JsonProperty("updateUserName")
  private String updateUserName = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonIgnore
  public MsSysMenuInfo menuId(Long menuId) {
    this.menuId = menuId;
    return this;
  }

   /**
   * 内部菜单id
   * @return menuId
  **/
  @ApiModelProperty(value = "内部菜单id")
  public Long getMenuId() {
    return menuId;
  }

  public void setMenuId(Long menuId) {
    this.menuId = menuId;
  }

  @JsonIgnore
  public MsSysMenuInfo menuName(String menuName) {
    this.menuName = menuName;
    return this;
  }

   /**
   * 菜单名称
   * @return menuName
  **/
  @ApiModelProperty(value = "菜单名称")
  public String getMenuName() {
    return menuName;
  }

  public void setMenuName(String menuName) {
    this.menuName = menuName;
  }

  @JsonIgnore
  public MsSysMenuInfo menuUrl(String menuUrl) {
    this.menuUrl = menuUrl;
    return this;
  }

   /**
   * 跳转地址
   * @return menuUrl
  **/
  @ApiModelProperty(value = "跳转地址")
  public String getMenuUrl() {
    return menuUrl;
  }

  public void setMenuUrl(String menuUrl) {
    this.menuUrl = menuUrl;
  }

  @JsonIgnore
  public MsSysMenuInfo parentId(Long parentId) {
    this.parentId = parentId;
    return this;
  }

   /**
   * 父菜单ID
   * @return parentId
  **/
  @ApiModelProperty(value = "父菜单ID")
  public Long getParentId() {
    return parentId;
  }

  public void setParentId(Long parentId) {
    this.parentId = parentId;
  }

  @JsonIgnore
  public MsSysMenuInfo menuOrder(Long menuOrder) {
    this.menuOrder = menuOrder;
    return this;
  }

   /**
   * 菜单顺序
   * @return menuOrder
  **/
  @ApiModelProperty(value = "菜单顺序")
  public Long getMenuOrder() {
    return menuOrder;
  }

  public void setMenuOrder(Long menuOrder) {
    this.menuOrder = menuOrder;
  }

  @JsonIgnore
  public MsSysMenuInfo menuDesc(String menuDesc) {
    this.menuDesc = menuDesc;
    return this;
  }

   /**
   * 菜单描述
   * @return menuDesc
  **/
  @ApiModelProperty(value = "菜单描述")
  public String getMenuDesc() {
    return menuDesc;
  }

  public void setMenuDesc(String menuDesc) {
    this.menuDesc = menuDesc;
  }

  @JsonIgnore
  public MsSysMenuInfo resourceCode(String resourceCode) {
    this.resourceCode = resourceCode;
    return this;
  }

   /**
   * 资源码
   * @return resourceCode
  **/
  @ApiModelProperty(value = "资源码")
  public String getResourceCode() {
    return resourceCode;
  }

  public void setResourceCode(String resourceCode) {
    this.resourceCode = resourceCode;
  }

  @JsonIgnore
  public MsSysMenuInfo status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态：1：正常，0：注销
   * @return status
  **/
  @ApiModelProperty(value = "状态：1：正常，0：注销")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsSysMenuInfo statusTime(String statusTime) {
    this.statusTime = statusTime;
    return this;
  }

   /**
   * 状态变更时间
   * @return statusTime
  **/
  @ApiModelProperty(value = "状态变更时间")
  public String getStatusTime() {
    return statusTime;
  }

  public void setStatusTime(String statusTime) {
    this.statusTime = statusTime;
  }

  @JsonIgnore
  public MsSysMenuInfo createUserId(String createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建人ID
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建人ID")
  public String getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public MsSysMenuInfo createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public MsSysMenuInfo createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsSysMenuInfo updateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
    return this;
  }

   /**
   * 更新人ID
   * @return updateUserId
  **/
  @ApiModelProperty(value = "更新人ID")
  public String getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
  }

  @JsonIgnore
  public MsSysMenuInfo updateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
    return this;
  }

   /**
   * 更新人姓名
   * @return updateUserName
  **/
  @ApiModelProperty(value = "更新人姓名")
  public String getUpdateUserName() {
    return updateUserName;
  }

  public void setUpdateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
  }

  @JsonIgnore
  public MsSysMenuInfo updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysMenuInfo sysMenuInfo = (MsSysMenuInfo) o;
    return Objects.equals(this.menuId, sysMenuInfo.menuId) &&
        Objects.equals(this.menuName, sysMenuInfo.menuName) &&
        Objects.equals(this.menuUrl, sysMenuInfo.menuUrl) &&
        Objects.equals(this.parentId, sysMenuInfo.parentId) &&
        Objects.equals(this.menuOrder, sysMenuInfo.menuOrder) &&
        Objects.equals(this.menuDesc, sysMenuInfo.menuDesc) &&
        Objects.equals(this.resourceCode, sysMenuInfo.resourceCode) &&
        Objects.equals(this.status, sysMenuInfo.status) &&
        Objects.equals(this.statusTime, sysMenuInfo.statusTime) &&
        Objects.equals(this.createUserId, sysMenuInfo.createUserId) &&
        Objects.equals(this.createUserName, sysMenuInfo.createUserName) &&
        Objects.equals(this.createTime, sysMenuInfo.createTime) &&
        Objects.equals(this.updateUserId, sysMenuInfo.updateUserId) &&
        Objects.equals(this.updateUserName, sysMenuInfo.updateUserName) &&
        Objects.equals(this.updateTime, sysMenuInfo.updateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(menuId, menuName, menuUrl, parentId, menuOrder, menuDesc, resourceCode, status, statusTime, createUserId, createUserName, createTime, updateUserId, updateUserName, updateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysMenuInfo {\n");
    
    sb.append("    menuId: ").append(toIndentedString(menuId)).append("\n");
    sb.append("    menuName: ").append(toIndentedString(menuName)).append("\n");
    sb.append("    menuUrl: ").append(toIndentedString(menuUrl)).append("\n");
    sb.append("    parentId: ").append(toIndentedString(parentId)).append("\n");
    sb.append("    menuOrder: ").append(toIndentedString(menuOrder)).append("\n");
    sb.append("    menuDesc: ").append(toIndentedString(menuDesc)).append("\n");
    sb.append("    resourceCode: ").append(toIndentedString(resourceCode)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    statusTime: ").append(toIndentedString(statusTime)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
    sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
