package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysOrgUserRelDTO {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("orgStructId")
  private Long orgStructId = null;

  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("createUserId")
  private String createUserId = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("fullSelectedFlag")
  private Boolean fullSelectedFlag = null;

  @JsonIgnore
  public MsSysOrgUserRelDTO id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsSysOrgUserRelDTO tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsSysOrgUserRelDTO orgStructId(Long orgStructId) {
    this.orgStructId = orgStructId;
    return this;
  }

   /**
   * 组织ID
   * @return orgStructId
  **/
  @ApiModelProperty(value = "组织ID")
  public Long getOrgStructId() {
    return orgStructId;
  }

  public void setOrgStructId(Long orgStructId) {
    this.orgStructId = orgStructId;
  }

  @JsonIgnore
  public MsSysOrgUserRelDTO userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 人员ID
   * @return userId
  **/
  @ApiModelProperty(value = "人员ID")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsSysOrgUserRelDTO createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsSysOrgUserRelDTO createUserId(String createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建人ID
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建人ID")
  public String getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public MsSysOrgUserRelDTO createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人名称
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人名称")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public MsSysOrgUserRelDTO fullSelectedFlag(Boolean fullSelectedFlag) {
    this.fullSelectedFlag = fullSelectedFlag;
    return this;
  }

   /**
   * 是否是全选标志，1是 0 否
   * @return fullSelectedFlag
  **/
  @ApiModelProperty(value = "是否是全选标志，1是 0 否")
  public Boolean getFullSelectedFlag() {
    return fullSelectedFlag;
  }

  public void setFullSelectedFlag(Boolean fullSelectedFlag) {
    this.fullSelectedFlag = fullSelectedFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysOrgUserRelDTO sysOrgUserRelDTO = (MsSysOrgUserRelDTO) o;
    return Objects.equals(this.id, sysOrgUserRelDTO.id) &&
        Objects.equals(this.tenantId, sysOrgUserRelDTO.tenantId) &&
        Objects.equals(this.orgStructId, sysOrgUserRelDTO.orgStructId) &&
        Objects.equals(this.userId, sysOrgUserRelDTO.userId) &&
        Objects.equals(this.createTime, sysOrgUserRelDTO.createTime) &&
        Objects.equals(this.createUserId, sysOrgUserRelDTO.createUserId) &&
        Objects.equals(this.createUserName, sysOrgUserRelDTO.createUserName) &&
        Objects.equals(this.fullSelectedFlag, sysOrgUserRelDTO.fullSelectedFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, tenantId, orgStructId, userId, createTime, createUserId, createUserName, fullSelectedFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysOrgUserRelDTO {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    orgStructId: ").append(toIndentedString(orgStructId)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    fullSelectedFlag: ").append(toIndentedString(fullSelectedFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
