package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ucenter.client.model.MsSysResourceLevelDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysResourceLevelDTO {
  @JsonProperty("resourceId")
  private Long resourceId = null;

  @JsonProperty("resourceCode")
  private String resourceCode = null;

  @JsonProperty("resourceName")
  private String resourceName = null;

  @JsonProperty("resourceType")
  private Integer resourceType = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("subResourceList")
  private List<MsSysResourceLevelDTO> subResourceList = new ArrayList<MsSysResourceLevelDTO>();

  @JsonIgnore
  public MsSysResourceLevelDTO resourceId(Long resourceId) {
    this.resourceId = resourceId;
    return this;
  }

   /**
   * 资源码ID
   * @return resourceId
  **/
  @ApiModelProperty(value = "资源码ID")
  public Long getResourceId() {
    return resourceId;
  }

  public void setResourceId(Long resourceId) {
    this.resourceId = resourceId;
  }

  @JsonIgnore
  public MsSysResourceLevelDTO resourceCode(String resourceCode) {
    this.resourceCode = resourceCode;
    return this;
  }

   /**
   * 资源码CODE
   * @return resourceCode
  **/
  @ApiModelProperty(value = "资源码CODE")
  public String getResourceCode() {
    return resourceCode;
  }

  public void setResourceCode(String resourceCode) {
    this.resourceCode = resourceCode;
  }

  @JsonIgnore
  public MsSysResourceLevelDTO resourceName(String resourceName) {
    this.resourceName = resourceName;
    return this;
  }

   /**
   * 资源码名称
   * @return resourceName
  **/
  @ApiModelProperty(value = "资源码名称")
  public String getResourceName() {
    return resourceName;
  }

  public void setResourceName(String resourceName) {
    this.resourceName = resourceName;
  }

  @JsonIgnore
  public MsSysResourceLevelDTO resourceType(Integer resourceType) {
    this.resourceType = resourceType;
    return this;
  }

   /**
   * 资源码类型：0:url 1:模块 2:页面，3页签，4按钮，5菜单，6服务
   * @return resourceType
  **/
  @ApiModelProperty(value = "资源码类型：0:url 1:模块 2:页面，3页签，4按钮，5菜单，6服务")
  public Integer getResourceType() {
    return resourceType;
  }

  public void setResourceType(Integer resourceType) {
    this.resourceType = resourceType;
  }

  @JsonIgnore
  public MsSysResourceLevelDTO createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsSysResourceLevelDTO subResourceList(List<MsSysResourceLevelDTO> subResourceList) {
    this.subResourceList = subResourceList;
    return this;
  }

  public MsSysResourceLevelDTO addSubResourceListItem(MsSysResourceLevelDTO subResourceListItem) {
    this.subResourceList.add(subResourceListItem);
    return this;
  }

   /**
   * 下级资源码列表
   * @return subResourceList
  **/
  @ApiModelProperty(value = "下级资源码列表")
  public List<MsSysResourceLevelDTO> getSubResourceList() {
    return subResourceList;
  }

  public void setSubResourceList(List<MsSysResourceLevelDTO> subResourceList) {
    this.subResourceList = subResourceList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysResourceLevelDTO sysResourceLevelDTO = (MsSysResourceLevelDTO) o;
    return Objects.equals(this.resourceId, sysResourceLevelDTO.resourceId) &&
        Objects.equals(this.resourceCode, sysResourceLevelDTO.resourceCode) &&
        Objects.equals(this.resourceName, sysResourceLevelDTO.resourceName) &&
        Objects.equals(this.resourceType, sysResourceLevelDTO.resourceType) &&
        Objects.equals(this.createTime, sysResourceLevelDTO.createTime) &&
        Objects.equals(this.subResourceList, sysResourceLevelDTO.subResourceList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resourceId, resourceCode, resourceName, resourceType, createTime, subResourceList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysResourceLevelDTO {\n");
    
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("    resourceCode: ").append(toIndentedString(resourceCode)).append("\n");
    sb.append("    resourceName: ").append(toIndentedString(resourceName)).append("\n");
    sb.append("    resourceType: ").append(toIndentedString(resourceType)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    subResourceList: ").append(toIndentedString(subResourceList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
