package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysResourcesetResourceRelDTO {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("resourceId")
  private Long resourceId = null;

  @JsonProperty("resourcesetId")
  private Long resourcesetId = null;

  @JsonProperty("createUserId")
  private String createUserId = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonIgnore
  public MsSysResourcesetResourceRelDTO id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsSysResourcesetResourceRelDTO resourceId(Long resourceId) {
    this.resourceId = resourceId;
    return this;
  }

   /**
   * 资源码ID
   * @return resourceId
  **/
  @ApiModelProperty(value = "资源码ID")
  public Long getResourceId() {
    return resourceId;
  }

  public void setResourceId(Long resourceId) {
    this.resourceId = resourceId;
  }

  @JsonIgnore
  public MsSysResourcesetResourceRelDTO resourcesetId(Long resourcesetId) {
    this.resourcesetId = resourcesetId;
    return this;
  }

   /**
   * 功能点ID
   * @return resourcesetId
  **/
  @ApiModelProperty(value = "功能点ID")
  public Long getResourcesetId() {
    return resourcesetId;
  }

  public void setResourcesetId(Long resourcesetId) {
    this.resourcesetId = resourcesetId;
  }

  @JsonIgnore
  public MsSysResourcesetResourceRelDTO createUserId(String createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建人ID
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建人ID")
  public String getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public MsSysResourcesetResourceRelDTO createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人名称
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人名称")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public MsSysResourcesetResourceRelDTO createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysResourcesetResourceRelDTO sysResourcesetResourceRelDTO = (MsSysResourcesetResourceRelDTO) o;
    return Objects.equals(this.id, sysResourcesetResourceRelDTO.id) &&
        Objects.equals(this.resourceId, sysResourcesetResourceRelDTO.resourceId) &&
        Objects.equals(this.resourcesetId, sysResourcesetResourceRelDTO.resourcesetId) &&
        Objects.equals(this.createUserId, sysResourcesetResourceRelDTO.createUserId) &&
        Objects.equals(this.createUserName, sysResourcesetResourceRelDTO.createUserName) &&
        Objects.equals(this.createTime, sysResourcesetResourceRelDTO.createTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, resourceId, resourcesetId, createUserId, createUserName, createTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysResourcesetResourceRelDTO {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("    resourcesetId: ").append(toIndentedString(resourcesetId)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
