package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysSassAccountDTO {
  @JsonProperty("accountId")
  private Long accountId = null;

  @JsonProperty("email")
  private String email = null;

  @JsonProperty("password")
  private String password = null;

  @JsonProperty("telPhone")
  private String telPhone = null;

  @JsonProperty("loginType")
  private Integer loginType = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("statusTime")
  private String statusTime = null;

  @JsonProperty("createUserId")
  private String createUserId = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("updateUserId")
  private String updateUserId = null;

  @JsonProperty("updateUserName")
  private String updateUserName = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonIgnore
  public MsSysSassAccountDTO accountId(Long accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * 主键ID
   * @return accountId
  **/
  @ApiModelProperty(value = "主键ID")
  public Long getAccountId() {
    return accountId;
  }

  public void setAccountId(Long accountId) {
    this.accountId = accountId;
  }

  @JsonIgnore
  public MsSysSassAccountDTO email(String email) {
    this.email = email;
    return this;
  }

   /**
   * 邮箱
   * @return email
  **/
  @ApiModelProperty(value = "邮箱")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  @JsonIgnore
  public MsSysSassAccountDTO password(String password) {
    this.password = password;
    return this;
  }

   /**
   * 密码
   * @return password
  **/
  @ApiModelProperty(value = "密码")
  public String getPassword() {
    return password;
  }

  public void setPassword(String password) {
    this.password = password;
  }

  @JsonIgnore
  public MsSysSassAccountDTO telPhone(String telPhone) {
    this.telPhone = telPhone;
    return this;
  }

   /**
   * 手机号
   * @return telPhone
  **/
  @ApiModelProperty(value = "手机号")
  public String getTelPhone() {
    return telPhone;
  }

  public void setTelPhone(String telPhone) {
    this.telPhone = telPhone;
  }

  @JsonIgnore
  public MsSysSassAccountDTO loginType(Integer loginType) {
    this.loginType = loginType;
    return this;
  }

   /**
   * 登陆方式： 0：手机；1：email
   * @return loginType
  **/
  @ApiModelProperty(value = "登陆方式： 0：手机；1：email")
  public Integer getLoginType() {
    return loginType;
  }

  public void setLoginType(Integer loginType) {
    this.loginType = loginType;
  }

  @JsonIgnore
  public MsSysSassAccountDTO status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 角色状态：1：正常，0：注销
   * @return status
  **/
  @ApiModelProperty(value = "角色状态：1：正常，0：注销")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsSysSassAccountDTO statusTime(String statusTime) {
    this.statusTime = statusTime;
    return this;
  }

   /**
   * 状态变更时间
   * @return statusTime
  **/
  @ApiModelProperty(value = "状态变更时间")
  public String getStatusTime() {
    return statusTime;
  }

  public void setStatusTime(String statusTime) {
    this.statusTime = statusTime;
  }

  @JsonIgnore
  public MsSysSassAccountDTO createUserId(String createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public MsSysSassAccountDTO createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public MsSysSassAccountDTO createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsSysSassAccountDTO updateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
    return this;
  }

   /**
   * 更新人ID
   * @return updateUserId
  **/
  @ApiModelProperty(value = "更新人ID")
  public String getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
  }

  @JsonIgnore
  public MsSysSassAccountDTO updateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
    return this;
  }

   /**
   * 更新人姓名
   * @return updateUserName
  **/
  @ApiModelProperty(value = "更新人姓名")
  public String getUpdateUserName() {
    return updateUserName;
  }

  public void setUpdateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
  }

  @JsonIgnore
  public MsSysSassAccountDTO updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysSassAccountDTO sysSassAccountDTO = (MsSysSassAccountDTO) o;
    return Objects.equals(this.accountId, sysSassAccountDTO.accountId) &&
        Objects.equals(this.email, sysSassAccountDTO.email) &&
        Objects.equals(this.password, sysSassAccountDTO.password) &&
        Objects.equals(this.telPhone, sysSassAccountDTO.telPhone) &&
        Objects.equals(this.loginType, sysSassAccountDTO.loginType) &&
        Objects.equals(this.status, sysSassAccountDTO.status) &&
        Objects.equals(this.statusTime, sysSassAccountDTO.statusTime) &&
        Objects.equals(this.createUserId, sysSassAccountDTO.createUserId) &&
        Objects.equals(this.createUserName, sysSassAccountDTO.createUserName) &&
        Objects.equals(this.createTime, sysSassAccountDTO.createTime) &&
        Objects.equals(this.updateUserId, sysSassAccountDTO.updateUserId) &&
        Objects.equals(this.updateUserName, sysSassAccountDTO.updateUserName) &&
        Objects.equals(this.updateTime, sysSassAccountDTO.updateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountId, email, password, telPhone, loginType, status, statusTime, createUserId, createUserName, createTime, updateUserId, updateUserName, updateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysSassAccountDTO {\n");
    
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    password: ").append(toIndentedString(password)).append("\n");
    sb.append("    telPhone: ").append(toIndentedString(telPhone)).append("\n");
    sb.append("    loginType: ").append(toIndentedString(loginType)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    statusTime: ").append(toIndentedString(statusTime)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
    sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
