package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysSassSmsValidcodeDTO {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("validcode")
  private String validcode = null;

  @JsonProperty("phone")
  private String phone = null;

  @JsonProperty("loginType")
  private Integer loginType = null;

  @JsonProperty("visitCount")
  private Integer visitCount = null;

  @JsonProperty("expireTime")
  private String expireTime = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("statusTime")
  private String statusTime = null;

  @JsonProperty("createUserId")
  private String createUserId = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("updateUserId")
  private String updateUserId = null;

  @JsonProperty("updateUserName")
  private String updateUserName = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonIgnore
  public MsSysSassSmsValidcodeDTO id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键ID
   * @return id
  **/
  @ApiModelProperty(value = "主键ID")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsSysSassSmsValidcodeDTO validcode(String validcode) {
    this.validcode = validcode;
    return this;
  }

   /**
   * 验证码
   * @return validcode
  **/
  @ApiModelProperty(value = "验证码")
  public String getValidcode() {
    return validcode;
  }

  public void setValidcode(String validcode) {
    this.validcode = validcode;
  }

  @JsonIgnore
  public MsSysSassSmsValidcodeDTO phone(String phone) {
    this.phone = phone;
    return this;
  }

   /**
   * 手机号
   * @return phone
  **/
  @ApiModelProperty(value = "手机号")
  public String getPhone() {
    return phone;
  }

  public void setPhone(String phone) {
    this.phone = phone;
  }

  @JsonIgnore
  public MsSysSassSmsValidcodeDTO loginType(Integer loginType) {
    this.loginType = loginType;
    return this;
  }

   /**
   * 登陆方式： 1注册，2验证码登录,3修改密码,4绑定手机,5绑定邮箱,6普通账号密码登录,7超级账号密码登录
   * @return loginType
  **/
  @ApiModelProperty(value = "登陆方式： 1注册，2验证码登录,3修改密码,4绑定手机,5绑定邮箱,6普通账号密码登录,7超级账号密码登录")
  public Integer getLoginType() {
    return loginType;
  }

  public void setLoginType(Integer loginType) {
    this.loginType = loginType;
  }

  @JsonIgnore
  public MsSysSassSmsValidcodeDTO visitCount(Integer visitCount) {
    this.visitCount = visitCount;
    return this;
  }

   /**
   * 验证码登陆次数
   * @return visitCount
  **/
  @ApiModelProperty(value = "验证码登陆次数")
  public Integer getVisitCount() {
    return visitCount;
  }

  public void setVisitCount(Integer visitCount) {
    this.visitCount = visitCount;
  }

  @JsonIgnore
  public MsSysSassSmsValidcodeDTO expireTime(String expireTime) {
    this.expireTime = expireTime;
    return this;
  }

   /**
   * 创建时间
   * @return expireTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getExpireTime() {
    return expireTime;
  }

  public void setExpireTime(String expireTime) {
    this.expireTime = expireTime;
  }

  @JsonIgnore
  public MsSysSassSmsValidcodeDTO status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态：1：正常，0：注销
   * @return status
  **/
  @ApiModelProperty(value = "状态：1：正常，0：注销")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsSysSassSmsValidcodeDTO statusTime(String statusTime) {
    this.statusTime = statusTime;
    return this;
  }

   /**
   * 状态变更时间
   * @return statusTime
  **/
  @ApiModelProperty(value = "状态变更时间")
  public String getStatusTime() {
    return statusTime;
  }

  public void setStatusTime(String statusTime) {
    this.statusTime = statusTime;
  }

  @JsonIgnore
  public MsSysSassSmsValidcodeDTO createUserId(String createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public MsSysSassSmsValidcodeDTO createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public MsSysSassSmsValidcodeDTO createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsSysSassSmsValidcodeDTO updateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
    return this;
  }

   /**
   * 更新人ID
   * @return updateUserId
  **/
  @ApiModelProperty(value = "更新人ID")
  public String getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
  }

  @JsonIgnore
  public MsSysSassSmsValidcodeDTO updateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
    return this;
  }

   /**
   * 更新人姓名
   * @return updateUserName
  **/
  @ApiModelProperty(value = "更新人姓名")
  public String getUpdateUserName() {
    return updateUserName;
  }

  public void setUpdateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
  }

  @JsonIgnore
  public MsSysSassSmsValidcodeDTO updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysSassSmsValidcodeDTO sysSassSmsValidcodeDTO = (MsSysSassSmsValidcodeDTO) o;
    return Objects.equals(this.id, sysSassSmsValidcodeDTO.id) &&
        Objects.equals(this.validcode, sysSassSmsValidcodeDTO.validcode) &&
        Objects.equals(this.phone, sysSassSmsValidcodeDTO.phone) &&
        Objects.equals(this.loginType, sysSassSmsValidcodeDTO.loginType) &&
        Objects.equals(this.visitCount, sysSassSmsValidcodeDTO.visitCount) &&
        Objects.equals(this.expireTime, sysSassSmsValidcodeDTO.expireTime) &&
        Objects.equals(this.status, sysSassSmsValidcodeDTO.status) &&
        Objects.equals(this.statusTime, sysSassSmsValidcodeDTO.statusTime) &&
        Objects.equals(this.createUserId, sysSassSmsValidcodeDTO.createUserId) &&
        Objects.equals(this.createUserName, sysSassSmsValidcodeDTO.createUserName) &&
        Objects.equals(this.createTime, sysSassSmsValidcodeDTO.createTime) &&
        Objects.equals(this.updateUserId, sysSassSmsValidcodeDTO.updateUserId) &&
        Objects.equals(this.updateUserName, sysSassSmsValidcodeDTO.updateUserName) &&
        Objects.equals(this.updateTime, sysSassSmsValidcodeDTO.updateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, validcode, phone, loginType, visitCount, expireTime, status, statusTime, createUserId, createUserName, createTime, updateUserId, updateUserName, updateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysSassSmsValidcodeDTO {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    validcode: ").append(toIndentedString(validcode)).append("\n");
    sb.append("    phone: ").append(toIndentedString(phone)).append("\n");
    sb.append("    loginType: ").append(toIndentedString(loginType)).append("\n");
    sb.append("    visitCount: ").append(toIndentedString(visitCount)).append("\n");
    sb.append("    expireTime: ").append(toIndentedString(expireTime)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    statusTime: ").append(toIndentedString(statusTime)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
    sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
