package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysUserDTO {
  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("accountId")
  private Long accountId = null;

  @JsonProperty("userCode")
  private String userCode = null;

  @JsonProperty("userNumber")
  private String userNumber = null;

  @JsonProperty("userName")
  private String userName = null;

  @JsonProperty("userPhone")
  private String userPhone = null;

  @JsonProperty("userSex")
  private Integer userSex = null;

  @JsonProperty("userEmailAddr")
  private String userEmailAddr = null;

  @JsonProperty("userIdCard")
  private String userIdCard = null;

  @JsonProperty("userPeriodTime")
  private String userPeriodTime = null;

  @JsonProperty("userWorkTel")
  private String userWorkTel = null;

  @JsonProperty("activeStatus")
  private Integer activeStatus = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("statusTime")
  private String statusTime = null;

  @JsonProperty("contactAddr")
  private String contactAddr = null;

  @JsonProperty("ticketOpeningTerminal")
  private String ticketOpeningTerminal = null;

  @JsonProperty("printingEquipment")
  private String printingEquipment = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("businessExtensionAttribute")
  private String businessExtensionAttribute = null;

  @JsonProperty("openapiUserObject")
  private String openapiUserObject = null;

  @JsonProperty("openapiUserType")
  private Integer openapiUserType = null;

  @JsonProperty("openapiUserPassword")
  private String openapiUserPassword = null;

  @JsonProperty("userType")
  private Integer userType = null;

  @JsonProperty("createUserId")
  private String createUserId = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("updateUserId")
  private String updateUserId = null;

  @JsonProperty("updateUserName")
  private String updateUserName = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonIgnore
  public MsSysUserDTO userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 主键ID
   * @return userId
  **/
  @ApiModelProperty(value = "主键ID")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsSysUserDTO tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsSysUserDTO accountId(Long accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * 登陆账号
   * @return accountId
  **/
  @ApiModelProperty(value = "登陆账号")
  public Long getAccountId() {
    return accountId;
  }

  public void setAccountId(Long accountId) {
    this.accountId = accountId;
  }

  @JsonIgnore
  public MsSysUserDTO userCode(String userCode) {
    this.userCode = userCode;
    return this;
  }

   /**
   * 人员代码
   * @return userCode
  **/
  @ApiModelProperty(value = "人员代码")
  public String getUserCode() {
    return userCode;
  }

  public void setUserCode(String userCode) {
    this.userCode = userCode;
  }

  @JsonIgnore
  public MsSysUserDTO userNumber(String userNumber) {
    this.userNumber = userNumber;
    return this;
  }

   /**
   * 人员工号
   * @return userNumber
  **/
  @ApiModelProperty(value = "人员工号")
  public String getUserNumber() {
    return userNumber;
  }

  public void setUserNumber(String userNumber) {
    this.userNumber = userNumber;
  }

  @JsonIgnore
  public MsSysUserDTO userName(String userName) {
    this.userName = userName;
    return this;
  }

   /**
   * 人员姓名
   * @return userName
  **/
  @ApiModelProperty(value = "人员姓名")
  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }

  @JsonIgnore
  public MsSysUserDTO userPhone(String userPhone) {
    this.userPhone = userPhone;
    return this;
  }

   /**
   * 手机号码
   * @return userPhone
  **/
  @ApiModelProperty(value = "手机号码")
  public String getUserPhone() {
    return userPhone;
  }

  public void setUserPhone(String userPhone) {
    this.userPhone = userPhone;
  }

  @JsonIgnore
  public MsSysUserDTO userSex(Integer userSex) {
    this.userSex = userSex;
    return this;
  }

   /**
   * 人员性别 0：男 1：女
   * @return userSex
  **/
  @ApiModelProperty(value = "人员性别 0：男 1：女")
  public Integer getUserSex() {
    return userSex;
  }

  public void setUserSex(Integer userSex) {
    this.userSex = userSex;
  }

  @JsonIgnore
  public MsSysUserDTO userEmailAddr(String userEmailAddr) {
    this.userEmailAddr = userEmailAddr;
    return this;
  }

   /**
   * 邮箱地址
   * @return userEmailAddr
  **/
  @ApiModelProperty(value = "邮箱地址")
  public String getUserEmailAddr() {
    return userEmailAddr;
  }

  public void setUserEmailAddr(String userEmailAddr) {
    this.userEmailAddr = userEmailAddr;
  }

  @JsonIgnore
  public MsSysUserDTO userIdCard(String userIdCard) {
    this.userIdCard = userIdCard;
    return this;
  }

   /**
   * 身份证号码
   * @return userIdCard
  **/
  @ApiModelProperty(value = "身份证号码")
  public String getUserIdCard() {
    return userIdCard;
  }

  public void setUserIdCard(String userIdCard) {
    this.userIdCard = userIdCard;
  }

  @JsonIgnore
  public MsSysUserDTO userPeriodTime(String userPeriodTime) {
    this.userPeriodTime = userPeriodTime;
    return this;
  }

   /**
   * 有效期
   * @return userPeriodTime
  **/
  @ApiModelProperty(value = "有效期")
  public String getUserPeriodTime() {
    return userPeriodTime;
  }

  public void setUserPeriodTime(String userPeriodTime) {
    this.userPeriodTime = userPeriodTime;
  }

  @JsonIgnore
  public MsSysUserDTO userWorkTel(String userWorkTel) {
    this.userWorkTel = userWorkTel;
    return this;
  }

   /**
   * 办公电话
   * @return userWorkTel
  **/
  @ApiModelProperty(value = "办公电话")
  public String getUserWorkTel() {
    return userWorkTel;
  }

  public void setUserWorkTel(String userWorkTel) {
    this.userWorkTel = userWorkTel;
  }

  @JsonIgnore
  public MsSysUserDTO activeStatus(Integer activeStatus) {
    this.activeStatus = activeStatus;
    return this;
  }

   /**
   * 激活状态 1：已激活  0：未激活
   * @return activeStatus
  **/
  @ApiModelProperty(value = "激活状态 1：已激活  0：未激活")
  public Integer getActiveStatus() {
    return activeStatus;
  }

  public void setActiveStatus(Integer activeStatus) {
    this.activeStatus = activeStatus;
  }

  @JsonIgnore
  public MsSysUserDTO status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态 1：启用  0：未启用 2:停用 3：关闭
   * @return status
  **/
  @ApiModelProperty(value = "状态 1：启用  0：未启用 2:停用 3：关闭")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsSysUserDTO statusTime(String statusTime) {
    this.statusTime = statusTime;
    return this;
  }

   /**
   * 状态变更时间
   * @return statusTime
  **/
  @ApiModelProperty(value = "状态变更时间")
  public String getStatusTime() {
    return statusTime;
  }

  public void setStatusTime(String statusTime) {
    this.statusTime = statusTime;
  }

  @JsonIgnore
  public MsSysUserDTO contactAddr(String contactAddr) {
    this.contactAddr = contactAddr;
    return this;
  }

   /**
   * 联系地址
   * @return contactAddr
  **/
  @ApiModelProperty(value = "联系地址")
  public String getContactAddr() {
    return contactAddr;
  }

  public void setContactAddr(String contactAddr) {
    this.contactAddr = contactAddr;
  }

  @JsonIgnore
  public MsSysUserDTO ticketOpeningTerminal(String ticketOpeningTerminal) {
    this.ticketOpeningTerminal = ticketOpeningTerminal;
    return this;
  }

   /**
   * 开票终端  多个开票终端用\",\"分隔开
   * @return ticketOpeningTerminal
  **/
  @ApiModelProperty(value = "开票终端  多个开票终端用\",\"分隔开")
  public String getTicketOpeningTerminal() {
    return ticketOpeningTerminal;
  }

  public void setTicketOpeningTerminal(String ticketOpeningTerminal) {
    this.ticketOpeningTerminal = ticketOpeningTerminal;
  }

  @JsonIgnore
  public MsSysUserDTO printingEquipment(String printingEquipment) {
    this.printingEquipment = printingEquipment;
    return this;
  }

   /**
   * 打印设备  多个打印设备值用\",\"隔开
   * @return printingEquipment
  **/
  @ApiModelProperty(value = "打印设备  多个打印设备值用\",\"隔开")
  public String getPrintingEquipment() {
    return printingEquipment;
  }

  public void setPrintingEquipment(String printingEquipment) {
    this.printingEquipment = printingEquipment;
  }

  @JsonIgnore
  public MsSysUserDTO invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型 c：普票；s：专票；cs：专票和普票 ce：普电票
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型 c：普票；s：专票；cs：专票和普票 ce：普电票")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public MsSysUserDTO businessExtensionAttribute(String businessExtensionAttribute) {
    this.businessExtensionAttribute = businessExtensionAttribute;
    return this;
  }

   /**
   * 业务扩展属性
   * @return businessExtensionAttribute
  **/
  @ApiModelProperty(value = "业务扩展属性")
  public String getBusinessExtensionAttribute() {
    return businessExtensionAttribute;
  }

  public void setBusinessExtensionAttribute(String businessExtensionAttribute) {
    this.businessExtensionAttribute = businessExtensionAttribute;
  }

  @JsonIgnore
  public MsSysUserDTO openapiUserObject(String openapiUserObject) {
    this.openapiUserObject = openapiUserObject;
    return this;
  }

   /**
   * 对象
   * @return openapiUserObject
  **/
  @ApiModelProperty(value = "对象")
  public String getOpenapiUserObject() {
    return openapiUserObject;
  }

  public void setOpenapiUserObject(String openapiUserObject) {
    this.openapiUserObject = openapiUserObject;
  }

  @JsonIgnore
  public MsSysUserDTO openapiUserType(Integer openapiUserType) {
    this.openapiUserType = openapiUserType;
    return this;
  }

   /**
   * 0伙伴;1客户;2代理商
   * @return openapiUserType
  **/
  @ApiModelProperty(value = "0伙伴;1客户;2代理商")
  public Integer getOpenapiUserType() {
    return openapiUserType;
  }

  public void setOpenapiUserType(Integer openapiUserType) {
    this.openapiUserType = openapiUserType;
  }

  @JsonIgnore
  public MsSysUserDTO openapiUserPassword(String openapiUserPassword) {
    this.openapiUserPassword = openapiUserPassword;
    return this;
  }

   /**
   * 密码
   * @return openapiUserPassword
  **/
  @ApiModelProperty(value = "密码")
  public String getOpenapiUserPassword() {
    return openapiUserPassword;
  }

  public void setOpenapiUserPassword(String openapiUserPassword) {
    this.openapiUserPassword = openapiUserPassword;
  }

  @JsonIgnore
  public MsSysUserDTO userType(Integer userType) {
    this.userType = userType;
    return this;
  }

   /**
   * 用户类型：0 默认用户;1 openApi用户
   * @return userType
  **/
  @ApiModelProperty(value = "用户类型：0 默认用户;1 openApi用户")
  public Integer getUserType() {
    return userType;
  }

  public void setUserType(Integer userType) {
    this.userType = userType;
  }

  @JsonIgnore
  public MsSysUserDTO createUserId(String createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public MsSysUserDTO createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public MsSysUserDTO createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsSysUserDTO updateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
    return this;
  }

   /**
   * 更新人ID
   * @return updateUserId
  **/
  @ApiModelProperty(value = "更新人ID")
  public String getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
  }

  @JsonIgnore
  public MsSysUserDTO updateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
    return this;
  }

   /**
   * 更新人姓名
   * @return updateUserName
  **/
  @ApiModelProperty(value = "更新人姓名")
  public String getUpdateUserName() {
    return updateUserName;
  }

  public void setUpdateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
  }

  @JsonIgnore
  public MsSysUserDTO updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysUserDTO sysUserDTO = (MsSysUserDTO) o;
    return Objects.equals(this.userId, sysUserDTO.userId) &&
        Objects.equals(this.tenantId, sysUserDTO.tenantId) &&
        Objects.equals(this.accountId, sysUserDTO.accountId) &&
        Objects.equals(this.userCode, sysUserDTO.userCode) &&
        Objects.equals(this.userNumber, sysUserDTO.userNumber) &&
        Objects.equals(this.userName, sysUserDTO.userName) &&
        Objects.equals(this.userPhone, sysUserDTO.userPhone) &&
        Objects.equals(this.userSex, sysUserDTO.userSex) &&
        Objects.equals(this.userEmailAddr, sysUserDTO.userEmailAddr) &&
        Objects.equals(this.userIdCard, sysUserDTO.userIdCard) &&
        Objects.equals(this.userPeriodTime, sysUserDTO.userPeriodTime) &&
        Objects.equals(this.userWorkTel, sysUserDTO.userWorkTel) &&
        Objects.equals(this.activeStatus, sysUserDTO.activeStatus) &&
        Objects.equals(this.status, sysUserDTO.status) &&
        Objects.equals(this.statusTime, sysUserDTO.statusTime) &&
        Objects.equals(this.contactAddr, sysUserDTO.contactAddr) &&
        Objects.equals(this.ticketOpeningTerminal, sysUserDTO.ticketOpeningTerminal) &&
        Objects.equals(this.printingEquipment, sysUserDTO.printingEquipment) &&
        Objects.equals(this.invoiceType, sysUserDTO.invoiceType) &&
        Objects.equals(this.businessExtensionAttribute, sysUserDTO.businessExtensionAttribute) &&
        Objects.equals(this.openapiUserObject, sysUserDTO.openapiUserObject) &&
        Objects.equals(this.openapiUserType, sysUserDTO.openapiUserType) &&
        Objects.equals(this.openapiUserPassword, sysUserDTO.openapiUserPassword) &&
        Objects.equals(this.userType, sysUserDTO.userType) &&
        Objects.equals(this.createUserId, sysUserDTO.createUserId) &&
        Objects.equals(this.createUserName, sysUserDTO.createUserName) &&
        Objects.equals(this.createTime, sysUserDTO.createTime) &&
        Objects.equals(this.updateUserId, sysUserDTO.updateUserId) &&
        Objects.equals(this.updateUserName, sysUserDTO.updateUserName) &&
        Objects.equals(this.updateTime, sysUserDTO.updateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userId, tenantId, accountId, userCode, userNumber, userName, userPhone, userSex, userEmailAddr, userIdCard, userPeriodTime, userWorkTel, activeStatus, status, statusTime, contactAddr, ticketOpeningTerminal, printingEquipment, invoiceType, businessExtensionAttribute, openapiUserObject, openapiUserType, openapiUserPassword, userType, createUserId, createUserName, createTime, updateUserId, updateUserName, updateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysUserDTO {\n");
    
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    userCode: ").append(toIndentedString(userCode)).append("\n");
    sb.append("    userNumber: ").append(toIndentedString(userNumber)).append("\n");
    sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
    sb.append("    userPhone: ").append(toIndentedString(userPhone)).append("\n");
    sb.append("    userSex: ").append(toIndentedString(userSex)).append("\n");
    sb.append("    userEmailAddr: ").append(toIndentedString(userEmailAddr)).append("\n");
    sb.append("    userIdCard: ").append(toIndentedString(userIdCard)).append("\n");
    sb.append("    userPeriodTime: ").append(toIndentedString(userPeriodTime)).append("\n");
    sb.append("    userWorkTel: ").append(toIndentedString(userWorkTel)).append("\n");
    sb.append("    activeStatus: ").append(toIndentedString(activeStatus)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    statusTime: ").append(toIndentedString(statusTime)).append("\n");
    sb.append("    contactAddr: ").append(toIndentedString(contactAddr)).append("\n");
    sb.append("    ticketOpeningTerminal: ").append(toIndentedString(ticketOpeningTerminal)).append("\n");
    sb.append("    printingEquipment: ").append(toIndentedString(printingEquipment)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    businessExtensionAttribute: ").append(toIndentedString(businessExtensionAttribute)).append("\n");
    sb.append("    openapiUserObject: ").append(toIndentedString(openapiUserObject)).append("\n");
    sb.append("    openapiUserType: ").append(toIndentedString(openapiUserType)).append("\n");
    sb.append("    openapiUserPassword: ").append(toIndentedString(openapiUserPassword)).append("\n");
    sb.append("    userType: ").append(toIndentedString(userType)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
    sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
