package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysUserGroupDTO {
  @JsonProperty("userGroupId")
  private Long userGroupId = null;

  @JsonProperty("userGroupCode")
  private String userGroupCode = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("userGroupName")
  private String userGroupName = null;

  @JsonProperty("userGroupDesc")
  private String userGroupDesc = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("statusTime")
  private String statusTime = null;

  @JsonProperty("createUserId")
  private String createUserId = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("updateUserId")
  private String updateUserId = null;

  @JsonProperty("updateUserName")
  private String updateUserName = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonIgnore
  public MsSysUserGroupDTO userGroupId(Long userGroupId) {
    this.userGroupId = userGroupId;
    return this;
  }

   /**
   * 主键
   * @return userGroupId
  **/
  @ApiModelProperty(value = "主键")
  public Long getUserGroupId() {
    return userGroupId;
  }

  public void setUserGroupId(Long userGroupId) {
    this.userGroupId = userGroupId;
  }

  @JsonIgnore
  public MsSysUserGroupDTO userGroupCode(String userGroupCode) {
    this.userGroupCode = userGroupCode;
    return this;
  }

   /**
   * 用户组代码
   * @return userGroupCode
  **/
  @ApiModelProperty(value = "用户组代码")
  public String getUserGroupCode() {
    return userGroupCode;
  }

  public void setUserGroupCode(String userGroupCode) {
    this.userGroupCode = userGroupCode;
  }

  @JsonIgnore
  public MsSysUserGroupDTO tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsSysUserGroupDTO userGroupName(String userGroupName) {
    this.userGroupName = userGroupName;
    return this;
  }

   /**
   * 用户组名称
   * @return userGroupName
  **/
  @ApiModelProperty(value = "用户组名称")
  public String getUserGroupName() {
    return userGroupName;
  }

  public void setUserGroupName(String userGroupName) {
    this.userGroupName = userGroupName;
  }

  @JsonIgnore
  public MsSysUserGroupDTO userGroupDesc(String userGroupDesc) {
    this.userGroupDesc = userGroupDesc;
    return this;
  }

   /**
   * 用户组功能描述
   * @return userGroupDesc
  **/
  @ApiModelProperty(value = "用户组功能描述")
  public String getUserGroupDesc() {
    return userGroupDesc;
  }

  public void setUserGroupDesc(String userGroupDesc) {
    this.userGroupDesc = userGroupDesc;
  }

  @JsonIgnore
  public MsSysUserGroupDTO status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 用户组状态：1：正常，0：注销
   * @return status
  **/
  @ApiModelProperty(value = "用户组状态：1：正常，0：注销")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsSysUserGroupDTO statusTime(String statusTime) {
    this.statusTime = statusTime;
    return this;
  }

   /**
   * 状态变更时间
   * @return statusTime
  **/
  @ApiModelProperty(value = "状态变更时间")
  public String getStatusTime() {
    return statusTime;
  }

  public void setStatusTime(String statusTime) {
    this.statusTime = statusTime;
  }

  @JsonIgnore
  public MsSysUserGroupDTO createUserId(String createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public MsSysUserGroupDTO createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public MsSysUserGroupDTO createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsSysUserGroupDTO updateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
    return this;
  }

   /**
   * 更新人ID
   * @return updateUserId
  **/
  @ApiModelProperty(value = "更新人ID")
  public String getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
  }

  @JsonIgnore
  public MsSysUserGroupDTO updateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
    return this;
  }

   /**
   * 更新人姓名
   * @return updateUserName
  **/
  @ApiModelProperty(value = "更新人姓名")
  public String getUpdateUserName() {
    return updateUserName;
  }

  public void setUpdateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
  }

  @JsonIgnore
  public MsSysUserGroupDTO updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysUserGroupDTO sysUserGroupDTO = (MsSysUserGroupDTO) o;
    return Objects.equals(this.userGroupId, sysUserGroupDTO.userGroupId) &&
        Objects.equals(this.userGroupCode, sysUserGroupDTO.userGroupCode) &&
        Objects.equals(this.tenantId, sysUserGroupDTO.tenantId) &&
        Objects.equals(this.userGroupName, sysUserGroupDTO.userGroupName) &&
        Objects.equals(this.userGroupDesc, sysUserGroupDTO.userGroupDesc) &&
        Objects.equals(this.status, sysUserGroupDTO.status) &&
        Objects.equals(this.statusTime, sysUserGroupDTO.statusTime) &&
        Objects.equals(this.createUserId, sysUserGroupDTO.createUserId) &&
        Objects.equals(this.createUserName, sysUserGroupDTO.createUserName) &&
        Objects.equals(this.createTime, sysUserGroupDTO.createTime) &&
        Objects.equals(this.updateUserId, sysUserGroupDTO.updateUserId) &&
        Objects.equals(this.updateUserName, sysUserGroupDTO.updateUserName) &&
        Objects.equals(this.updateTime, sysUserGroupDTO.updateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userGroupId, userGroupCode, tenantId, userGroupName, userGroupDesc, status, statusTime, createUserId, createUserName, createTime, updateUserId, updateUserName, updateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysUserGroupDTO {\n");
    
    sb.append("    userGroupId: ").append(toIndentedString(userGroupId)).append("\n");
    sb.append("    userGroupCode: ").append(toIndentedString(userGroupCode)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    userGroupName: ").append(toIndentedString(userGroupName)).append("\n");
    sb.append("    userGroupDesc: ").append(toIndentedString(userGroupDesc)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    statusTime: ").append(toIndentedString(statusTime)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
    sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
