package com.xforceplus.ucenter.client.api;

import com.xforceplus.ucenter.client.model.MsGetLogListRequest;
import com.xforceplus.ucenter.client.model.MsGetLogListResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "log", description = "the log API")
public interface LogApi {

    @ApiOperation(value = "获取日志列表", notes = "", response = MsGetLogListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "log", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetLogListResponse.class) })
    @RequestMapping(value = "/log/getLogList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetLogListResponse getLogList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetLogListRequest request);

}
