package com.xforceplus.ucenter.client.api;

import com.xforceplus.ucenter.client.model.MsGetOpenApiUserDetailRequest;
import com.xforceplus.ucenter.client.model.MsGetOpenApiUserDetailResponse;
import com.xforceplus.ucenter.client.model.MsGetOpenApiUserListRequest;
import com.xforceplus.ucenter.client.model.MsGetOpenApiUserListResponse;
import com.xforceplus.ucenter.client.model.MsOperateOpenApiUserRequest;
import com.xforceplus.ucenter.client.model.MsOperateOpenApiUserResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "openapiuser", description = "the openapiuser API")
public interface OpenapiuserApi {

    @ApiOperation(value = "获取OpenApiUser信息", notes = "", response = MsGetOpenApiUserDetailResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysOpenApiUser", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetOpenApiUserDetailResponse.class) })
    @RequestMapping(value = "/openapiuser/getOpenApiUserDetail",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetOpenApiUserDetailResponse getOpenApiUserDetail(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetOpenApiUserDetailRequest request);


    @ApiOperation(value = "获取OpenApiUser列表", notes = "", response = MsGetOpenApiUserListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysOpenApiUser", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetOpenApiUserListResponse.class) })
    @RequestMapping(value = "/openapiuser/getOpenApiUserList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetOpenApiUserListResponse getOpenApiUserList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetOpenApiUserListRequest request);


    @ApiOperation(value = "操作OpenApiUser信息", notes = "", response = MsOperateOpenApiUserResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysOpenApiUser", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsOperateOpenApiUserResponse.class) })
    @RequestMapping(value = "/openapiuser/operateOpenApiUser",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsOperateOpenApiUserResponse operateOpenApiUser(@ApiParam(value = "request" ,required=true ) @RequestBody MsOperateOpenApiUserRequest request);

}
