package com.xforceplus.ucenter.client.api;

import com.xforceplus.ucenter.client.model.*;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * add by liusong 2019/9/30 16:21
 **/
@Api(value = "orgcompanyno", description = "the orgcompanyno API")
public interface OrgCompanyNoApi {
    @ApiOperation(value = "操作组织公司编号", notes = "", response = MsCommonResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SysOrgCompanyNo", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = MsCommonResponse.class) })
    @RequestMapping(value = "/orgcompanyno/operateOrgCompanyNo",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsCommonResponse operateOrgCompanyNo(@ApiParam(value = "request" ,required=true ) @RequestBody MsOperateOrgCompanyNoRequest request);

    @ApiOperation(value = "获取公司编号列表", notes = "", response = MsGetOrgCompanyNoListResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SysOrgCompanyNo", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = MsGetOrgCompanyNoListResponse.class) })
    @RequestMapping(value = "/orgstruct/getOrgCompanyNoList",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsGetOrgCompanyNoListResponse getOrgCompanyNoList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetOrgCompanyNoListRequest request);
}
