package com.xforceplus.ucenter.client.api;

import com.xforceplus.ucenter.client.model.*;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "resource", description = "the resource API")
public interface ResourceApi {

    @ApiOperation(value = "判断是否具有该路径权限", notes = "", response = MsCheckExistsPathResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysResource", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsCheckExistsPathResponse.class) })
    @RequestMapping(value = "/resource/checkExistsPath",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsCheckExistsPathResponse checkExistsPath(@ApiParam(value = "request" ,required=true ) @RequestBody MsCheckExistsPathRequest request);


    @ApiOperation(value = "判断是否具有该资源码", notes = "", response = MsCheckExistsResourceResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysResource", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsCheckExistsResourceResponse.class) })
    @RequestMapping(value = "/resource/checkExistsResource",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsCheckExistsResourceResponse checkExistsResource(@ApiParam(value = "request" ,required=true ) @RequestBody MsCheckExistsResourceRequest request);


    @ApiOperation(value = "根据userId获取资源码信息", notes = "", response = MsGetPathsByUserIdResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysResource", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetPathsByUserIdResponse.class) })
    @RequestMapping(value = "/resource/getPathsByUserId",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetPathsByUserIdResponse getPathsByUserId(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetPathsByUserIdRequest request);


    @ApiOperation(value = "根据apiUrl获取资源码信息", notes = "", response = MsGetResourceByApiUrlResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysResource", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetResourceByApiUrlResponse.class) })
    @RequestMapping(value = "/resource/getResourceByApiUrl",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetResourceByApiUrlResponse getResourceByApiUrl(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetResourceByApiUrlRequest request);


    @ApiOperation(value = "根据userId获取资源码信息", notes = "", response = MsGetResourceByUserIdResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysResource", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetResourceByUserIdResponse.class) })
    @RequestMapping(value = "/resource/getResourceByUserId",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetResourceByUserIdResponse getResourceByUserId(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetResourceByUserIdRequest request);


    @ApiOperation(value = "获取资源码信息", notes = "", response = MsGetResourceDetailResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysResource", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetResourceDetailResponse.class) })
    @RequestMapping(value = "/resource/getResourceDetail",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetResourceDetailResponse getResourceDetail(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetResourceDetailRequest request);


    @ApiOperation(value = "根据userId分层获取资源码信息", notes = "", response = MsGetResourceLevelByUserIdResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysResource", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetResourceLevelByUserIdResponse.class) })
    @RequestMapping(value = "/resource/getResourceLevelByUserId",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetResourceLevelByUserIdResponse getResourceLevelByUserId(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetResourceLevelByUserIdRequest request);


    @ApiOperation(value = "获取资源码列表", notes = "", response = MsGetResourceListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysResource", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetResourceListResponse.class) })
    @RequestMapping(value = "/resource/getResourceList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetResourceListResponse getResourceList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetResourceListRequest request);


    @ApiOperation(value = "获取资源码子集列表", notes = "", response = MsGetResourceSubListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysResource", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetResourceSubListResponse.class) })
    @RequestMapping(value = "/resource/getResourceSubList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetResourceSubListResponse getResourceSubList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetResourceSubListRequest request);


    @ApiOperation(value = "操作资源码", notes = "", response = MsOperateResourceResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysResource", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsOperateResourceResponse.class) })
    @RequestMapping(value = "/resource/operateResource",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsOperateResourceResponse operateResource(@ApiParam(value = "request" ,required=true ) @RequestBody MsOperateResourceRequest request);

    @ApiOperation(value = "获取资源码子集列表", notes = "", response = MsGetResourceSubListResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SysResource", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = MsGetSecondResourceListResponse.class) })
    @RequestMapping(value = "/resource/getSecondList",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsGetSecondResourceListResponse getSecondResourceList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetSecondResourceListRequest request);

}
